/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Unclaim
implements LandlordCommand {
    private Landlord plugin;

    public Unclaim(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            int numFree;
            Double amt;
            LowOwnedLand dbLand;
            String worldname;
            int z;
            int x;
            Chunk currChunk;
            Player player;
            block14: {
                player = (Player)sender;
                if (!player.hasPermission("landlord.player.own") && !player.hasPermission("landlord.admin.unclaim")) {
                    player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                    return true;
                }
                currChunk = player.getLocation().getChunk();
                x = currChunk.getX();
                z = currChunk.getZ();
                worldname = currChunk.getWorld().getName();
                List disabledWorlds = this.plugin.getConfig().getStringList("disabled-worlds");
                for (String s : disabledWorlds) {
                    if (!s.equalsIgnoreCase(currChunk.getWorld().getName())) continue;
                    player.sendMessage(ChatColor.RED + "Vous ne pouvez pas claim dans ce monde.");
                    return true;
                }
                if (args.length > 1) {
                    block15: {
                        String[] coords = args[1].split(",");
                        x = Integer.parseInt(coords[0]);
                        z = Integer.parseInt(coords[1]);
                        currChunk = currChunk.getWorld().getChunkAt(x, z);
                        if (args.length <= 2) break block14;
                        if (this.plugin.getServer().getWorld(worldname) != null) break block15;
                        player.sendMessage(ChatColor.RED + "Le monde '" + worldname + "' n'existe pas.");
                        return true;
                    }
                    try {
                        currChunk = Bukkit.getWorld((String)worldname).getChunkAt(x, z);
                    }
                    catch (NumberFormatException e) {
                        player.sendMessage(ChatColor.RED + "usage: /" + label + " " + args[0] + " [x,z] [monde]");
                        return true;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        player.sendMessage(ChatColor.RED + "usage: /" + label + " " + args[0] + " [x,z] [monde]");
                        return true;
                    }
                }
            }
            if ((dbLand = LowOwnedLand.getLandFromDatabase(x, z, worldname)) == null || !dbLand.getOwnerName().equalsIgnoreCase(player.getName()) && !player.hasPermission("landlord.admin.unclaim")) {
                player.sendMessage(ChatColor.RED + "Vous ne poss\u00e9dez aucun terrain.");
                return true;
            }
            if (this.plugin.hasVault() && this.plugin.getvHandler().hasEconomy() && (amt = Double.valueOf(this.plugin.getConfig().getDouble("economy.sellPrice", 100.0))) > 0.0 && ((numFree = this.plugin.getConfig().getInt("economy.freeLand", 0)) <= 0 || this.plugin.getDatabase().find(OwnedLand.class).where().eq("ownerName", (Object)player.getName()).findRowCount() > numFree) && this.plugin.getvHandler().giveCash(player, amt)) {
                player.sendMessage(ChatColor.GREEN + "Ce terrain se vend " + this.plugin.getvHandler().formatCash(amt) + ".");
            }
            if (!player.getName().equalsIgnoreCase(dbLand.getOwnerName())) {
                player.sendMessage(ChatColor.YELLOW + "Le terrain de " + dbLand.getOwnerName() + " a \u00e9t\u00e9 unclaim.");
            }
            dbLand.highlightLand(player, Effect.WITCH_MAGIC);
            dbLand.delete();
            sender.sendMessage(ChatColor.YELLOW + "Le chunk (" + currChunk.getX() + ", " + currChunk.getZ() + ") dans le monde '" + currChunk.getWorld().getName() + "' a bien \u00e9t\u00e9 unclaim.");
            if (this.plugin.getConfig().getBoolean("options.regenOnUnclaim", false)) {
                currChunk.getWorld().regenerateChunk(currChunk.getX(), currChunk.getZ());
            }
            if (this.plugin.getConfig().getBoolean("options.soundEffects", true)) {
                player.playSound(player.getLocation(), Sound.ENDERMAN_HIT, 10.0f, 0.5f);
            }
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd} [x,z] [world]";
        String desc = "Unclaim le chunk.";
        String priceWarning = "Gagnez #{pricetag} par unclaim.";
        String regenWarning = "Chunk reg\u00e9n\u00e9r\u00e9!";
        String helpString = "";
        helpString = String.valueOf(helpString) + Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
        if (this.plugin.hasVault() && this.plugin.getvHandler().hasEconomy() && this.plugin.getConfig().getDouble("economy.sellPrice", 50.0) > 0.0) {
            helpString = String.valueOf(helpString) + ChatColor.YELLOW + " " + ChatColor.ITALIC + priceWarning.replace("#{pricetag}", this.plugin.getvHandler().formatCash(this.plugin.getConfig().getDouble("economy.sellPrice", 50.0)));
        }
        if (this.plugin.getConfig().getBoolean("options.regenOnUnclaim", false)) {
            helpString = String.valueOf(helpString) + ChatColor.RED + " " + ChatColor.ITALIC + regenWarning;
        }
        return helpString;
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"unclaim", "sell"};
    }
}

