/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.util.NumberConversions;

public class LandList
implements LandlordCommand {
    private Landlord plugin;

    public LandList(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            List myLand;
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.own")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            int pageNumber = 1;
            if (args.length > 1) {
                try {
                    pageNumber = Integer.parseInt(args[1]);
                }
                catch (NumberFormatException e) {
                    player.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                    return true;
                }
            }
            if ((myLand = this.plugin.getDatabase().find(OwnedLand.class).where().eq("ownerName", (Object)player.getName()).findList()).size() == 0) {
                player.sendMessage(ChatColor.YELLOW + "Vous ne poss\u00e9dez aucun terrain!");
            } else {
                String header = ChatColor.DARK_GREEN + " | Coordonn\u00e9es - Coordonn\u00e9es du chunk - Nom du monde |     \n";
                ArrayList<String> landList = new ArrayList<String>();
                for (OwnedLand aMyLand : myLand) {
                    LowOwnedLand lowLand = aMyLand.getLowLand();
                    landList.add(ChatColor.GOLD + " (" + lowLand.getXBlock() + ", " + lowLand.getZBlock() + ") - (" + lowLand.getX() + ", " + lowLand.getZ() + ") - " + lowLand.getWorldName() + "\n");
                }
                int numPerPage = 7;
                int numPages = NumberConversions.ceil((double)((double)landList.size() / 7.0));
                if (pageNumber > numPages) {
                    player.sendMessage(ChatColor.RED + "Le num\u00e9ro de page n'est pas valide.");
                    return true;
                }
                String pMsg = ChatColor.DARK_GREEN + "--- " + ChatColor.YELLOW + "Vos terrains" + ChatColor.DARK_GREEN + " ---" + ChatColor.YELLOW + " Page " + pageNumber + ChatColor.DARK_GREEN + " ---\n" + header;
                if (pageNumber == numPages) {
                    int i = 7 * pageNumber - 7;
                    while (i < landList.size()) {
                        pMsg = String.valueOf(pMsg) + (String)landList.get(i);
                        ++i;
                    }
                    pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "------------------------------";
                } else {
                    int i = 7 * pageNumber - 7;
                    while (i < 7 * pageNumber) {
                        pMsg = String.valueOf(pMsg) + (String)landList.get(i);
                        ++i;
                    }
                    pMsg = String.valueOf(pMsg) + ChatColor.DARK_GREEN + "--- fa\u00eetes" + ChatColor.YELLOW + " /" + label + " list " + (pageNumber + 1) + ChatColor.DARK_GREEN + " pour voir la page suivante (" + pageNumber + "/" + numPages + ") ---";
                }
                player.sendMessage(pMsg);
            }
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd}";
        String desc = "Liste tous vos terrains.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"list"};
    }
}

