/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Info
implements LandlordCommand {
    private Landlord plugin;

    public Info(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.info")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            Chunk currChunk = player.getLocation().getChunk();
            LowOwnedLand land = LowOwnedLand.getLandFromDatabase(currChunk.getX(), currChunk.getZ(), currChunk.getWorld().getName());
            String owner = ChatColor.GRAY + ChatColor.ITALIC + "Personne";
            if (land != null) {
                owner = ChatColor.GOLD + land.getOwnerUsername();
            } else {
                land = LowOwnedLand.landFromProperties(null, currChunk);
            }
            if (this.plugin.getConfig().getBoolean("options.particleEffects")) {
                land.highlightLand(player, Effect.LAVADRIP);
            }
            String msg = ChatColor.DARK_GREEN + "--- Vous \u00eates dans le chunk " + ChatColor.GOLD + "(" + currChunk.getX() + ", " + currChunk.getZ() + ") " + ChatColor.DARK_GREEN + " dans le monde \"" + ChatColor.GOLD + currChunk.getWorld().getName() + ChatColor.DARK_GREEN + "\"\n" + "----- Il appartient \u00e0 : " + owner;
            player.sendMessage(msg);
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.player.info")) {
            return null;
        }
        String usage = "/#{label} #{cmd}";
        String desc = "Affiche les infos du terrain.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"info"};
    }
}

