/*
 * Decompiled with CFR 0.152.
 */
package net.sacredlabyrinth.phaed.simpleclans.commands;

import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.List;
import net.sacredlabyrinth.phaed.simpleclans.ChatBlock;
import net.sacredlabyrinth.phaed.simpleclans.ClanPlayer;
import net.sacredlabyrinth.phaed.simpleclans.Helper;
import net.sacredlabyrinth.phaed.simpleclans.SimpleClans;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class LeaderboardCommand {
    public void execute(Player player, String[] arg) {
        SimpleClans plugin = SimpleClans.getInstance();
        String headColor = plugin.getSettingsManager().getPageHeadingsColor();
        String subColor = plugin.getSettingsManager().getPageSubTitleColor();
        DecimalFormat formatter = new DecimalFormat("#.#");
        if (arg.length == 0) {
            if (plugin.getPermissionsManager().has(player, "simpleclans.anyone.leaderboard")) {
                List<ClanPlayer> clanPlayers = plugin.getClanManager().getAllClanPlayers();
                plugin.getClanManager().sortClanPlayersByKDR(clanPlayers);
                ChatBlock chatBlock = new ChatBlock();
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.saySingle((CommandSender)player, plugin.getSettingsManager().getServerName() + subColor + " " + plugin.getLang("leaderboard.command") + " " + headColor + Helper.generatePageSeparator(plugin.getSettingsManager().getPageSep()));
                ChatBlock.sendBlank((CommandSender)player);
                ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("total.clan.players.0"), subColor + clanPlayers.size()));
                ChatBlock.sendBlank((CommandSender)player);
                chatBlock.setAlignment("c", "l", "c", "c", "c", "c");
                chatBlock.addRow("  " + headColor + plugin.getLang("rank"), plugin.getLang("player"), plugin.getLang("kdr"), plugin.getLang("clan"), plugin.getLang("seen"));
                int rank = 1;
                for (ClanPlayer cp : clanPlayers) {
                    Player p = cp.toPlayer();
                    boolean isOnline = false;
                    if (p != null) {
                        isOnline = true;
                    }
                    String name = (cp.isLeader() ? plugin.getSettingsManager().getPageLeaderColor() : (cp.isTrusted() ? plugin.getSettingsManager().getPageTrustedColor() : plugin.getSettingsManager().getPageUnTrustedColor())) + cp.getName();
                    String lastSeen = isOnline ? ChatColor.GREEN + plugin.getLang("online") : ChatColor.WHITE + cp.getLastSeenDaysString();
                    String clanTag = ChatColor.WHITE + plugin.getLang("free.agent");
                    if (cp.getClan() != null) {
                        clanTag = cp.getClan().getColorTag();
                    }
                    chatBlock.addRow("  " + rank, name, ChatColor.YELLOW + "" + formatter.format(cp.getKDR()), ChatColor.WHITE + clanTag, lastSeen);
                    ++rank;
                }
                boolean more = chatBlock.sendBlock((CommandSender)player, plugin.getSettingsManager().getPageSize());
                if (more) {
                    plugin.getStorageManager().addChatBlock((CommandSender)player, chatBlock);
                    ChatBlock.sendBlank((CommandSender)player);
                    ChatBlock.sendMessage((CommandSender)player, headColor + MessageFormat.format(plugin.getLang("view.next.page"), plugin.getSettingsManager().getCommandMore()));
                }
                ChatBlock.sendBlank((CommandSender)player);
            } else {
                ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + plugin.getLang("insufficient.permissions"));
            }
        } else {
            ChatBlock.sendMessage((CommandSender)player, ChatColor.RED + MessageFormat.format(plugin.getLang("usage.0.leaderboard"), plugin.getSettingsManager().getCommandClan()));
        }
    }
}

