/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.persistantData;

import com.avaje.ebean.validation.NotNull;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.bukkit.Chunk;

@Entity
@Table(name="ll_land")
public class OwnedLand {
    @Id
    private int id;
    @NotNull
    private String ownerName;
    @NotNull
    private int x;
    @NotNull
    private int z;
    @NotNull
    private String worldName;
    @OneToMany(cascade={CascadeType.ALL})
    List<Friend> friends;
    private String permissions;

    public LowOwnedLand getLowLand() {
        return this.getLowLand(true);
    }

    public LowOwnedLand getLowLand(boolean search) {
        return LowOwnedLand.getLandFromDatabase(this, search);
    }

    public void setProperties(String playerName, Chunk c) {
        this.ownerName = playerName;
        this.setX(c.getX());
        this.setZ(c.getZ());
        this.setWorldName(c.getWorld().getName());
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setFriends(List<Friend> friends) {
        this.friends = friends;
    }

    public List<Friend> getFriends() {
        return this.friends;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getZ() {
        return this.z;
    }

    public void setPermissions(String permissions) {
        this.permissions = permissions;
    }

    public String getPermissions() {
        return this.permissions;
    }
}

