/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Unfriend
implements LandlordCommand {
    private Landlord plugin;

    public Unfriend(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            if (args.length < 2) {
                sender.sendMessage(ChatColor.RED + "usage: /land unfriend <player>");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.own")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            Chunk currChunk = player.getLocation().getChunk();
            Friend frd = Friend.friendFromOfflinePlayer(args[1]);
            LowOwnedLand land = LowOwnedLand.getLandFromDatabase(currChunk.getX(), currChunk.getZ(), currChunk.getWorld().getName());
            if (land == null || !land.getOwnerName().equalsIgnoreCase(player.getName()) && !player.hasPermission("landlord.admin.modifyfriends")) {
                player.sendMessage(ChatColor.RED + "Vous ne poss\u00e9dez pas ce terrain.");
                return true;
            }
            if (!land.removeFriend(frd)) {
                player.sendMessage(ChatColor.YELLOW + "Le joueur " + args[1] + " n'est pas un friend de ce terrain.");
                return true;
            }
            if (this.plugin.getConfig().getBoolean("options.particleEffects", true)) {
                land.highlightLand(player, Effect.VILLAGER_THUNDERCLOUD, 2);
            }
            land.save();
            if (this.plugin.getConfig().getBoolean("options.soundEffects", true)) {
                player.playSound(player.getLocation(), Sound.ZOMBIE_INFECT, 10.0f, 0.5f);
            }
            player.sendMessage(ChatColor.GREEN + "Le joueur " + args[1] + " n'est plus un friend de ce terrain.");
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd} <player>";
        String desc = "Enl\u00e8ve un ami du terrain.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"unfriend", "remfriend"};
    }
}

