/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Manage
implements LandlordCommand {
    private Landlord plugin;

    public Manage(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.own")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            if (this.plugin.getFlagManager().getRegisteredFlags().size() <= 0) {
                player.sendMessage(ChatColor.RED + "Il n'y a rien \u00e0 modifier!");
                return true;
            }
            Chunk currChunk = player.getLocation().getChunk();
            LowOwnedLand land = LowOwnedLand.getLandFromDatabase(currChunk.getX(), currChunk.getZ(), currChunk.getWorld().getName());
            if (land == null || !land.getOwnerName().equalsIgnoreCase(player.getName()) && !player.hasPermission("landlord.admin.manage")) {
                player.sendMessage(ChatColor.RED + "Vous n'\u00eates pas le propri\u00e9taire de ce terrain.");
                return true;
            }
            if (!land.getOwnerName().equalsIgnoreCase(player.getName())) {
                player.sendMessage(ChatColor.YELLOW + "Vous modifiez le terrain d'autrui.");
            }
            this.plugin.getManageViewManager().activateView(player, land);
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd}";
        String desc = "Modifie les permissions du terrain.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"manage"};
    }
}

