/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.User;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Home
implements LandlordCommand {
    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Seul les joueurs peuvent faire cette commande!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && player.hasPermission("landlord.player.home")) {
            this.teleportToHome(player);
        } else if (args.length == 2 && player.hasPermission("landlord.admin.home")) {
            this.teleportToHome(player, args[1]);
        } else {
            player.sendMessage(ChatColor.RED + "Votre commande n'est pas valide");
        }
        return true;
    }

    private void teleportToHome(Player player) {
        User user = (User)Landlord.getInstance().getDatabase().find(User.class).where().eq("userName", (Object)player.getName()).findUnique();
        if (user == null) {
            player.sendMessage(ChatColor.RED + "Votre home n'existe pas");
        } else {
            Location loc = user.getHomeLocation();
            if (loc != null) {
                LowOwnedLand land = LowOwnedLand.getApplicableLand(loc);
                if (land != null && (land.getOwnerName().equalsIgnoreCase(player.getName()) || land.isFriend(player))) {
                    if (loc.getBlock().getType() != Material.AIR && !loc.getBlock().getType().isTransparent()) {
                        loc = loc.getWorld().getHighestBlockAt(loc).getLocation();
                    }
                    player.teleport(loc);
                    player.sendMessage(ChatColor.GREEN + "Vous avez \u00e9t\u00e9 t\u00e9l\u00e9port\u00e9 \u00e0 votre home");
                } else {
                    player.sendMessage(ChatColor.RED + "Vous home doit \u00eatre sur un terrain au moins friend");
                }
            } else {
                player.sendMessage(ChatColor.RED + "Votre home n'est pas valide");
            }
        }
    }

    private void teleportToHome(Player executor, String playerName) {
        User user = (User)Landlord.getInstance().getDatabase().find(User.class).where().eq("userName", (Object)playerName).findUnique();
        if (user == null) {
            executor.sendMessage(ChatColor.RED + "Ce home n'existe pas");
        } else {
            Location loc = user.getHomeLocation();
            if (loc != null) {
                executor.teleport(loc);
                executor.sendMessage(ChatColor.GREEN + "Vous avez \u00e9t\u00e9 t\u00e9l\u00e9port\u00e9 au home de " + playerName);
                executor.sendMessage(ChatColor.GRAY + "(Vous avez peut-\u00eatre \u00e9t\u00e9 t\u00e9l\u00e9port\u00e9 alors que le propri\u00e9taire du home n'en aurait pas eu le droit)");
            } else {
                executor.sendMessage(ChatColor.RED + "Le home n'est pas valide");
            }
        }
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.player.sethome")) {
            return null;
        }
        String usage = "/#{label} #{cmd}";
        String desc = "Se t\u00e9l\u00e9porte au home \u00e0 la position.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"home"};
    }
}

