/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import com.jcdesimp.landlord.persistantData.User;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Chunk;
import org.bukkit.Effect;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Claim
implements LandlordCommand {
    private Landlord plugin;

    public Claim(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            int numFree;
            Double amt;
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.own")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            Chunk currChunk = player.getLocation().getChunk();
            List disabledWorlds = this.plugin.getConfig().getStringList("disabled-worlds");
            for (String s : disabledWorlds) {
                if (!s.equalsIgnoreCase(currChunk.getWorld().getName())) continue;
                player.sendMessage(ChatColor.RED + "Vous ne pouvez pas claim dans ce monde.");
                return true;
            }
            if (this.plugin.hasWorldGuard() && !this.plugin.getWgHandler().canClaim(player, currChunk)) {
                player.sendMessage(ChatColor.RED + "Vous ne pouvez pas claim ici.");
                return true;
            }
            LowOwnedLand land = LowOwnedLand.landFromProperties(player, currChunk);
            LowOwnedLand dbLand = LowOwnedLand.getLandFromDatabase(currChunk.getX(), currChunk.getZ(), currChunk.getWorld().getName());
            if (dbLand != null) {
                if (dbLand.getOwnerName().equalsIgnoreCase(player.getName())) {
                    player.sendMessage(ChatColor.YELLOW + "Vous \u00eates d\u00e9j\u00e0 le propri\u00e9taire de ce terrain!");
                    return true;
                }
                player.sendMessage(ChatColor.YELLOW + "Quelqu'un poss\u00e8de d\u00e9j\u00e0 ce terrain.");
                return true;
            }
            int orLimit = this.plugin.getConfig().getInt("limits.landLimit", 10);
            int limit = this.plugin.getConfig().getInt("limits.landLimit", 10);
            if (player.hasPermission("landlord.limit.extra5")) {
                limit = orLimit + this.plugin.getConfig().getInt("limits.extra5", 0);
            } else if (player.hasPermission("landlord.limit.extra4")) {
                limit = orLimit + this.plugin.getConfig().getInt("limits.extra4", 0);
            } else if (player.hasPermission("landlord.limit.extra3")) {
                limit = orLimit + this.plugin.getConfig().getInt("limits.extra3", 0);
            } else if (player.hasPermission("landlord.limit.extra2")) {
                limit = orLimit + this.plugin.getConfig().getInt("limits.extra2", 0);
            } else if (player.hasPermission("landlord.limit.extra")) {
                limit = orLimit + this.plugin.getConfig().getInt("limits.extra", 0);
            }
            if (limit >= 0 && !player.hasPermission("landlord.limit.override") && this.plugin.getDatabase().find(OwnedLand.class).where().eq("ownerName", (Object)player.getName()).findRowCount() >= limit) {
                player.sendMessage(ChatColor.RED + "Vous ne pouvez pas poss\u00e9der plus de " + limit + " terrains.");
                return true;
            }
            if (this.plugin.hasVault() && this.plugin.getvHandler().hasEconomy() && (amt = Double.valueOf(this.plugin.getConfig().getDouble("economy.buyPrice", 100.0))) > 0.0 && ((numFree = this.plugin.getConfig().getInt("economy.freeLand", 0)) <= 0 || this.plugin.getDatabase().find(OwnedLand.class).where().eq("ownerName", (Object)player.getName()).findRowCount() >= numFree)) {
                if (!this.plugin.getvHandler().chargeCash(player, amt)) {
                    player.sendMessage(ChatColor.RED + "Cela co\u00fbte " + this.plugin.getvHandler().formatCash(amt) + " d'acheter ce terrain.");
                    return true;
                }
                player.sendMessage(ChatColor.YELLOW + "Vous avez d\u00e9bours\u00e9 " + this.plugin.getvHandler().formatCash(amt) + " pour acheter ce terrain.");
            }
            land.save();
            land.highlightLand(player, Effect.HAPPY_VILLAGER);
            User user = (User)Landlord.getInstance().getDatabase().find(User.class).where().eq("userName", (Object)player.getName()).findUnique();
            if (user == null) {
                user = new User();
                user.setUserName(player.getName());
                user.setHomeLocation(player.getLocation());
                Landlord.getInstance().getDatabase().save((Object)user);
                player.sendMessage(ChatColor.GREEN + "Votre home a \u00e9t\u00e9 plac\u00e9 (/land home)");
            }
            sender.sendMessage(ChatColor.GREEN + "Vous avez claim avec succ\u00e8s le chunk (" + currChunk.getX() + ", " + currChunk.getZ() + ") dans le monde '" + currChunk.getWorld().getName() + "'.");
            if (this.plugin.getConfig().getBoolean("options.soundEffects", true)) {
                player.playSound(player.getLocation(), Sound.FIREWORK_TWINKLE2, 10.0f, 10.0f);
            }
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        String usage = "/#{label} #{cmd}";
        String desc = "Claim ce terrain.";
        String priceWarning = "Cela co\u00fbte #{pricetag} de claim.";
        String helpString = "";
        helpString = String.valueOf(helpString) + Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
        if (this.plugin.hasVault() && this.plugin.getvHandler().hasEconomy() && this.plugin.getConfig().getDouble("economy.buyPrice", 100.0) > 0.0) {
            helpString = String.valueOf(helpString) + ChatColor.YELLOW + " " + ChatColor.ITALIC + priceWarning.replace("#{pricetag}", this.plugin.getvHandler().formatCash(this.plugin.getConfig().getDouble("economy.buyPrice", 100.0)));
        }
        return helpString;
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"claim", "buy"};
    }
}

