/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord;

import com.avaje.ebean.EbeanServer;
import com.jcdesimp.landlord.LandAlerter;
import com.jcdesimp.landlord.LandListener;
import com.jcdesimp.landlord.LandlordCommandExecutor;
import com.jcdesimp.landlord.configuration.CustomConfig;
import com.jcdesimp.landlord.landFlags.Build;
import com.jcdesimp.landlord.landFlags.HarmAnimals;
import com.jcdesimp.landlord.landFlags.OpenDoor;
import com.jcdesimp.landlord.landFlags.PVP;
import com.jcdesimp.landlord.landFlags.TntDamage;
import com.jcdesimp.landlord.landFlags.UseContainers;
import com.jcdesimp.landlord.landFlags.UseRedstone;
import com.jcdesimp.landlord.landManagement.FlagManager;
import com.jcdesimp.landlord.landManagement.ViewManager;
import com.jcdesimp.landlord.persistantData.DBVersion;
import com.jcdesimp.landlord.persistantData.Friend;
import com.jcdesimp.landlord.persistantData.LandFlagPerm;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.MyDatabase;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import com.jcdesimp.landlord.persistantData.User;
import com.jcdesimp.landlord.pluginHooks.VaultHandler;
import com.jcdesimp.landlord.pluginHooks.WorldguardHandler;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import java.util.ArrayList;
import java.util.List;
import net.milkbowl.vault.Vault;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Landlord
extends JavaPlugin {
    private MyDatabase database;
    private static Landlord plugin;
    private WorldguardHandler wgHandler;
    private VaultHandler vHandler;
    private FlagManager flagManager;
    private ViewManager manageViewManager;
    private LandAlerter pListen;
    private CustomConfig mainConfig;
    private CustomConfig messagesConfig;

    public void onEnable() {
        plugin = this;
        this.flagManager = new FlagManager(this);
        this.manageViewManager = new ViewManager();
        this.mainConfig = new CustomConfig(this, "config.yml", "config.yml");
        this.messagesConfig = new CustomConfig(this, "messages/english.yml", "messages/" + this.mainConfig.get().getString("options.messagesFile").replace("/", "."));
        this.pListen = new LandAlerter();
        if (this.getConfig().getBoolean("options.showLandAlerts", true)) {
            this.getServer().getPluginManager().registerEvents((Listener)this.pListen, (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)new LandListener(), (Plugin)this);
        this.setupDatabase();
        this.getLogger().info("Cr\u00e9e par Jcdesimp et modifi\u00e9 par rudelune!");
        this.getCommand("landlord").setExecutor((CommandExecutor)new LandlordCommandExecutor(this));
        if (!this.hasWorldGuard() && this.getConfig().getBoolean("worldguard.blockRegionClaim", true)) {
            this.getLogger().warning("Worldguard not found, worldguard features disabled.");
        } else if (this.hasWorldGuard()) {
            this.getLogger().info("Worldguard found!");
            this.wgHandler = new WorldguardHandler(this.getWorldGuard());
        }
        if (!this.hasVault() && this.getConfig().getBoolean("economy.enable", true)) {
            this.getLogger().warning("Vault not found, economy features disabled.");
        } else if (this.hasVault()) {
            this.getLogger().info("Vault found!");
            this.vHandler = new VaultHandler();
            if (!this.vHandler.hasEconomy()) {
                this.getLogger().warning("No economy found, economy features disabled.");
            }
        }
        if (this.getConfig().getBoolean("enabled-flags.build")) {
            this.flagManager.registerFlag(new Build());
        }
        if (this.getConfig().getBoolean("enabled-flags.harmAnimals")) {
            this.flagManager.registerFlag(new HarmAnimals());
        }
        if (this.getConfig().getBoolean("enabled-flags.useContainers")) {
            this.flagManager.registerFlag(new UseContainers());
        }
        if (this.getConfig().getBoolean("enabled-flags.tntDamage")) {
            this.flagManager.registerFlag(new TntDamage());
        }
        if (this.getConfig().getBoolean("enabled-flags.useRedstone")) {
            this.flagManager.registerFlag(new UseRedstone());
        }
        if (this.getConfig().getBoolean("enabled-flags.openDoor")) {
            this.flagManager.registerFlag(new OpenDoor());
        }
        if (this.getConfig().getBoolean("enabled-flags.pvp")) {
            this.flagManager.registerFlag(new PVP());
        }
        LowOwnedLand.load();
    }

    public void onDisable() {
        this.getLogger().info(String.valueOf(this.getDescription().getName()) + " has been disabled!");
        this.manageViewManager.deactivateAll();
        this.pListen.clearPtrack();
    }

    public FileConfiguration getConfig() {
        return this.mainConfig.get();
    }

    public FileConfiguration getMessages() {
        return this.messagesConfig.get();
    }

    public FlagManager getFlagManager() {
        return this.flagManager;
    }

    public ViewManager getManageViewManager() {
        return this.manageViewManager;
    }

    public static Landlord getInstance() {
        return plugin;
    }

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        return (WorldGuardPlugin)plugin;
    }

    public WorldguardHandler getWgHandler() {
        return this.wgHandler;
    }

    public boolean hasWorldGuard() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("WorldGuard");
        return plugin != null && plugin instanceof WorldGuardPlugin && this.getConfig().getBoolean("worldguard.blockRegionClaim", true);
    }

    public boolean hasVault() {
        Plugin plugin = this.getServer().getPluginManager().getPlugin("Vault");
        return plugin != null && plugin instanceof Vault && this.getConfig().getBoolean("economy.enable", true);
    }

    public VaultHandler getvHandler() {
        return this.vHandler;
    }

    private void setupDatabase() {
        FileConfiguration config = this.getConfig();
        this.database = new MyDatabase(this){

            @Override
            protected List<Class<?>> getDatabaseClasses() {
                ArrayList list = new ArrayList();
                list.add(OwnedLand.class);
                list.add(Friend.class);
                list.add(DBVersion.class);
                list.add(LandFlagPerm.class);
                list.add(User.class);
                return list;
            }
        };
        this.database.initializeDatabase(config.getString("database.driver", "org.sqlite.JDBC"), config.getString("database.url", "jdbc:sqlite:{DIR}{NAME}.db"), config.getString("database.username", "bukkit"), config.getString("database.password", "walrus"), config.getString("database.isolation", "SERIALIZABLE"), config.getBoolean("database.logging", false), config.getBoolean("database.rebuild", false));
        config.set("database.rebuild", (Object)false);
    }

    public EbeanServer getDatabase() {
        return this.database.getDatabase();
    }
}

