/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.injector.network;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import net.minecraft.server.v1_11_R1.PacketDecoder;
import net.minecraft.server.v1_11_R1.PacketEncoder;
import protocolsupport.protocol.pipeline.common.LogicHandler;
import protocolsupport.protocol.pipeline.initial.InitialPacketDecoder;
import protocolsupport.protocol.pipeline.timeout.SimpleReadTimeoutHandler;
import protocolsupport.protocol.storage.ProtocolStorage;
import protocolsupport.utils.Utils;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.impl.spigot.SpigotConnectionImpl;
import protocolsupport.zplatform.impl.spigot.network.handler.SpigotFakePacketListener;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotPacketDecoder;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotPacketEncoder;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotWrappedPrepender;
import protocolsupport.zplatform.impl.spigot.network.pipeline.SpigotWrappedSplitter;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public class SpigotServerConnectionChannel
extends ChannelInitializer<Channel> {
    private static final boolean replaceDecoderEncoder = Utils.getJavaPropertyValue("replaceencoderdecoder", false, Utils.Converter.STRING_TO_BOOLEAN);

    protected void initChannel(Channel channel) {
        NetworkManagerWrapper networkmanager = ServerPlatform.get().getMiscUtils().getNetworkManagerFromChannel(channel);
        networkmanager.setPacketListener(new SpigotFakePacketListener());
        SpigotConnectionImpl connection = new SpigotConnectionImpl(networkmanager);
        connection.storeInChannel(channel);
        ProtocolStorage.addConnection(channel.remoteAddress(), connection);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addAfter("timeout", "ps_initial_decoder", (ChannelHandler)new InitialPacketDecoder());
        pipeline.addBefore("packet_handler", "ps_logic", (ChannelHandler)new LogicHandler(connection));
        pipeline.remove("legacy_query");
        pipeline.replace("timeout", "timeout", (ChannelHandler)new SimpleReadTimeoutHandler(30));
        pipeline.replace("splitter", "splitter", (ChannelHandler)new SpigotWrappedSplitter());
        pipeline.replace("prepender", "prepender", (ChannelHandler)new SpigotWrappedPrepender());
        if (replaceDecoderEncoder) {
            if (pipeline.get("decoder").getClass().equals(PacketDecoder.class)) {
                pipeline.replace("decoder", "decoder", (ChannelHandler)new SpigotPacketDecoder());
            }
            if (pipeline.get("encoder").getClass().equals(PacketEncoder.class)) {
                pipeline.replace("encoder", "encoder", (ChannelHandler)new SpigotPacketEncoder());
            }
        }
    }
}

