/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone;

import com.flowpowered.network.Codec;
import com.flowpowered.network.Message;
import com.flowpowered.network.service.CodecLookupService;
import java.lang.reflect.Field;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import net.glowstone.GlowServer;
import net.glowstone.entity.meta.profile.PlayerProfile;
import net.glowstone.net.handler.play.player.UseItemMessage;
import net.glowstone.net.message.KickMessage;
import net.glowstone.net.message.SetCompressionMessage;
import net.glowstone.net.message.handshake.HandshakeMessage;
import net.glowstone.net.message.login.EncryptionKeyRequestMessage;
import net.glowstone.net.message.login.EncryptionKeyResponseMessage;
import net.glowstone.net.message.login.LoginStartMessage;
import net.glowstone.net.message.login.LoginSuccessMessage;
import net.glowstone.net.message.play.entity.AnimateEntityMessage;
import net.glowstone.net.message.play.entity.AttachEntityMessage;
import net.glowstone.net.message.play.entity.CollectItemMessage;
import net.glowstone.net.message.play.entity.DestroyEntitiesMessage;
import net.glowstone.net.message.play.entity.EntityEffectMessage;
import net.glowstone.net.message.play.entity.EntityEquipmentMessage;
import net.glowstone.net.message.play.entity.EntityHeadRotationMessage;
import net.glowstone.net.message.play.entity.EntityMetadataMessage;
import net.glowstone.net.message.play.entity.EntityPropertyMessage;
import net.glowstone.net.message.play.entity.EntityRemoveEffectMessage;
import net.glowstone.net.message.play.entity.EntityRotationMessage;
import net.glowstone.net.message.play.entity.EntityStatusMessage;
import net.glowstone.net.message.play.entity.EntityTeleportMessage;
import net.glowstone.net.message.play.entity.EntityVelocityMessage;
import net.glowstone.net.message.play.entity.RelativeEntityPositionMessage;
import net.glowstone.net.message.play.entity.RelativeEntityPositionRotationMessage;
import net.glowstone.net.message.play.entity.SetCooldownMessage;
import net.glowstone.net.message.play.entity.SetPassengerMessage;
import net.glowstone.net.message.play.entity.SpawnLightningStrikeMessage;
import net.glowstone.net.message.play.entity.SpawnMobMessage;
import net.glowstone.net.message.play.entity.SpawnObjectMessage;
import net.glowstone.net.message.play.entity.SpawnPaintingMessage;
import net.glowstone.net.message.play.entity.SpawnXpOrbMessage;
import net.glowstone.net.message.play.entity.VehicleMoveMessage;
import net.glowstone.net.message.play.game.BlockActionMessage;
import net.glowstone.net.message.play.game.BlockChangeMessage;
import net.glowstone.net.message.play.game.ChatMessage;
import net.glowstone.net.message.play.game.ChunkDataMessage;
import net.glowstone.net.message.play.game.ClientSettingsMessage;
import net.glowstone.net.message.play.game.ExperienceMessage;
import net.glowstone.net.message.play.game.ExplosionMessage;
import net.glowstone.net.message.play.game.HealthMessage;
import net.glowstone.net.message.play.game.IncomingChatMessage;
import net.glowstone.net.message.play.game.JoinGameMessage;
import net.glowstone.net.message.play.game.MapDataMessage;
import net.glowstone.net.message.play.game.MultiBlockChangeMessage;
import net.glowstone.net.message.play.game.NamedSoundEffectMessage;
import net.glowstone.net.message.play.game.PingMessage;
import net.glowstone.net.message.play.game.PlayEffectMessage;
import net.glowstone.net.message.play.game.PlayParticleMessage;
import net.glowstone.net.message.play.game.PluginMessage;
import net.glowstone.net.message.play.game.PositionRotationMessage;
import net.glowstone.net.message.play.game.RespawnMessage;
import net.glowstone.net.message.play.game.SignEditorMessage;
import net.glowstone.net.message.play.game.SoundEffectMessage;
import net.glowstone.net.message.play.game.SpawnPositionMessage;
import net.glowstone.net.message.play.game.StateChangeMessage;
import net.glowstone.net.message.play.game.StatisticMessage;
import net.glowstone.net.message.play.game.TimeMessage;
import net.glowstone.net.message.play.game.TitleMessage;
import net.glowstone.net.message.play.game.UnloadChunkMessage;
import net.glowstone.net.message.play.game.UpdateBlockEntityMessage;
import net.glowstone.net.message.play.game.UpdateSignMessage;
import net.glowstone.net.message.play.game.UserListHeaderFooterMessage;
import net.glowstone.net.message.play.game.UserListItemMessage;
import net.glowstone.net.message.play.game.WorldBorderMessage;
import net.glowstone.net.message.play.inv.CloseWindowMessage;
import net.glowstone.net.message.play.inv.CreativeItemMessage;
import net.glowstone.net.message.play.inv.EnchantItemMessage;
import net.glowstone.net.message.play.inv.HeldItemMessage;
import net.glowstone.net.message.play.inv.OpenWindowMessage;
import net.glowstone.net.message.play.inv.SetWindowContentsMessage;
import net.glowstone.net.message.play.inv.SetWindowSlotMessage;
import net.glowstone.net.message.play.inv.TransactionMessage;
import net.glowstone.net.message.play.inv.WindowClickMessage;
import net.glowstone.net.message.play.inv.WindowPropertyMessage;
import net.glowstone.net.message.play.player.BlockPlacementMessage;
import net.glowstone.net.message.play.player.BossBarMessage;
import net.glowstone.net.message.play.player.CameraMessage;
import net.glowstone.net.message.play.player.ClientStatusMessage;
import net.glowstone.net.message.play.player.CombatEventMessage;
import net.glowstone.net.message.play.player.DiggingMessage;
import net.glowstone.net.message.play.player.InteractEntityMessage;
import net.glowstone.net.message.play.player.PlayerAbilitiesMessage;
import net.glowstone.net.message.play.player.PlayerActionMessage;
import net.glowstone.net.message.play.player.PlayerLookMessage;
import net.glowstone.net.message.play.player.PlayerPositionLookMessage;
import net.glowstone.net.message.play.player.PlayerPositionMessage;
import net.glowstone.net.message.play.player.PlayerSwingArmMessage;
import net.glowstone.net.message.play.player.PlayerUpdateMessage;
import net.glowstone.net.message.play.player.ResourcePackSendMessage;
import net.glowstone.net.message.play.player.ResourcePackStatusMessage;
import net.glowstone.net.message.play.player.ServerDifficultyMessage;
import net.glowstone.net.message.play.player.SpectateMessage;
import net.glowstone.net.message.play.player.SteerVehicleMessage;
import net.glowstone.net.message.play.player.TabCompleteMessage;
import net.glowstone.net.message.play.player.TabCompleteResponseMessage;
import net.glowstone.net.message.play.player.TeleportConfirmMessage;
import net.glowstone.net.message.play.player.UseBedMessage;
import net.glowstone.net.message.play.scoreboard.ScoreboardDisplayMessage;
import net.glowstone.net.message.play.scoreboard.ScoreboardObjectiveMessage;
import net.glowstone.net.message.play.scoreboard.ScoreboardScoreMessage;
import net.glowstone.net.message.play.scoreboard.ScoreboardTeamMessage;
import net.glowstone.net.message.status.StatusPingMessage;
import net.glowstone.net.message.status.StatusRequestMessage;
import net.glowstone.net.message.status.StatusResponseMessage;
import net.glowstone.net.protocol.GlowProtocol;
import net.glowstone.net.protocol.ProtocolType;
import net.glowstone.util.TextMessage;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.WorldType;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.events.ServerPingResponseEvent;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.protocol.utils.types.Position;
import protocolsupport.utils.ReflectionUtils;
import protocolsupport.zplatform.PlatformPacketFactory;

public class GlowStonePacketFactory
implements PlatformPacketFactory {
    private static final int INBOUND = 0;
    private static final int OUTBOUND = 1;

    public Message createInboundInventoryClosePacket() {
        return new CloseWindowMessage(0);
    }

    public Message createOutboundChatPacket(String message, int position) {
        return new ChatMessage(new TextMessage(message), position);
    }

    public Message createTabHeaderFooterPacket(BaseComponent header, BaseComponent footer) {
        return new UserListHeaderFooterMessage(new TextMessage(header.toLegacyText()), new TextMessage(header.toLegacyText()));
    }

    public Message createTitleResetPacket() {
        return new TitleMessage(TitleMessage.Action.RESET);
    }

    public Message createTitleClearPacket() {
        return new TitleMessage(TitleMessage.Action.CLEAR);
    }

    public Message createTitleMainPacket(String title) {
        return new TitleMessage(TitleMessage.Action.TITLE, new TextMessage(title));
    }

    public Message createTitleSubPacket(String title) {
        return new TitleMessage(TitleMessage.Action.SUBTITLE, new TextMessage(title));
    }

    public Message createTitleParamsPacket(int fadeIn, int stay, int fadeOut) {
        return new TitleMessage(TitleMessage.Action.TIMES, fadeIn, stay, fadeOut);
    }

    public Message createLoginDisconnectPacket(String message) {
        return new KickMessage(message);
    }

    public Message createPlayDisconnectPacket(String message) {
        return new KickMessage(message);
    }

    public Message createLoginEncryptionBeginPacket(PublicKey publicKey, byte[] randomBytes) {
        return new EncryptionKeyRequestMessage("", publicKey.getEncoded(), randomBytes);
    }

    public Message createSetCompressionPacket(int threshold) {
        return new SetCompressionMessage(threshold);
    }

    public Message createBlockBreakSoundPacket(Position pos, Material type) {
        return null;
    }

    public Message createStatusPongPacket(long pingId) {
        return new StatusPingMessage(pingId);
    }

    public Message createStausServerInfoPacket(List<String> profiles, ServerPingResponseEvent.ProtocolInfo info, String icon, String motd, int maxPlayers) {
        GlowServer server = (GlowServer)Bukkit.getServer();
        JSONObject json = new JSONObject();
        JSONObject version = new JSONObject();
        version.put((Object)"name", (Object)info.getName());
        version.put((Object)"protocol", (Object)info.getId());
        json.put((Object)"version", (Object)version);
        JSONObject players = new JSONObject();
        players.put((Object)"max", (Object)maxPlayers);
        players.put((Object)"online", (Object)profiles.size());
        if (!profiles.isEmpty()) {
            JSONArray playerSample = new JSONArray();
            UUID randomUUID = UUID.randomUUID();
            PlayerProfile[] playerProfiles = new PlayerProfile[profiles.size()];
            for (int i = 0; i < profiles.size(); ++i) {
                playerProfiles[i] = new PlayerProfile(profiles.get(i), randomUUID);
            }
            for (PlayerProfile profile : playerProfiles = Arrays.copyOfRange(playerProfiles, 0, Math.min(playerProfiles.length, server.getPlayerSampleCount()))) {
                JSONObject sample = new JSONObject();
                sample.put((Object)"name", (Object)profile.getName());
                sample.put((Object)"id", (Object)profile.getUniqueId().toString());
                playerSample.add((Object)sample);
            }
            players.put((Object)"sample", (Object)playerSample);
        }
        json.put((Object)"players", (Object)players);
        JSONObject description = new JSONObject();
        description.put((Object)"text", (Object)motd);
        json.put((Object)"description", (Object)description);
        if (icon != null && !icon.isEmpty()) {
            json.put((Object)"favicon", (Object)icon);
        }
        JSONArray modList = new JSONArray();
        JSONObject modinfo = new JSONObject();
        modinfo.put((Object)"type", (Object)"vanilla");
        modinfo.put((Object)"modList", (Object)modList);
        modinfo.put((Object)"clientModsAllowed", (Object)true);
        json.put((Object)"modinfo", (Object)modinfo);
        return new StatusResponseMessage(json);
    }

    public Message createLoginSuccessPacket(GameProfile profile) {
        return new LoginSuccessMessage(profile.getUUID().toString(), profile.getName());
    }

    public Message createEmptyCustomPayloadPacket(String tag) {
        return new PluginMessage(tag, new byte[0]);
    }

    public Message createFakeJoinGamePacket() {
        return new JoinGameMessage(0, 0, 0, 0, 0, WorldType.NORMAL.name(), false);
    }

    @Override
    public int getOutLoginDisconnectPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 1, KickMessage.class);
    }

    @Override
    public int getOutLoginEncryptionBeginPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 1, EncryptionKeyRequestMessage.class);
    }

    @Override
    public int getOutLoginSuccessPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 1, LoginSuccessMessage.class);
    }

    @Override
    public int getOutLoginSetCompressionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 1, SetCompressionMessage.class);
    }

    @Override
    public int getOutStatusServerInfoPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.STATUS, 1, StatusResponseMessage.class);
    }

    @Override
    public int getOutStatusPongPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.STATUS, 1, StatusPingMessage.class);
    }

    @Override
    public int getOutPlayKeepAlivePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PingMessage.class);
    }

    @Override
    public int getOutPlayLoginPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, JoinGameMessage.class);
    }

    @Override
    public int getOutPlayChatPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ChatMessage.class);
    }

    @Override
    public int getOutPlayUpdateTimePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, TimeMessage.class);
    }

    @Override
    public int getOutPlayEntityEquipmentPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityEquipmentMessage.class);
    }

    @Override
    public int getOutPlaySpawnPositionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnPositionMessage.class);
    }

    @Override
    public int getOutPlayUpdateHealthPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, HealthMessage.class);
    }

    @Override
    public int getOutPlayRespawnPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, RespawnMessage.class);
    }

    @Override
    public int getOutPlayPositionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PositionRotationMessage.class);
    }

    @Override
    public int getOutPlayHeldSlotPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, HeldItemMessage.class);
    }

    @Override
    public int getOutPlayBedPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, UseBedMessage.class);
    }

    @Override
    public int getOutPlayAnimationPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, AnimateEntityMessage.class);
    }

    @Override
    public int getOutPlaySpawnNamedPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnMobMessage.class);
    }

    @Override
    public int getOutPlayCollectEffectPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, CollectItemMessage.class);
    }

    @Override
    public int getOutPlaySpawnObjectPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnObjectMessage.class);
    }

    @Override
    public int getOutPlaySpawnLivingPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnMobMessage.class);
    }

    @Override
    public int getOutPlaySpawnPaintingPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnPaintingMessage.class);
    }

    @Override
    public int getOutPlaySpawnExpOrbPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnXpOrbMessage.class);
    }

    @Override
    public int getOutPlayEntityVelocityPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityVelocityMessage.class);
    }

    @Override
    public int getOutPlayEntityDestroyPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, DestroyEntitiesMessage.class);
    }

    @Override
    public int getOutPlayEntityPacketId() {
        return 40;
    }

    @Override
    public int getOutPlayEntityRelMovePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, RelativeEntityPositionMessage.class);
    }

    @Override
    public int getOutPlayEntityLookPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityRotationMessage.class);
    }

    @Override
    public int getOutPlayEntityRelMoveLookPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, RelativeEntityPositionRotationMessage.class);
    }

    @Override
    public int getOutPlayEntityTeleportPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityTeleportMessage.class);
    }

    @Override
    public int getOutPlayEntityHeadRotationPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityHeadRotationMessage.class);
    }

    @Override
    public int getOutPlayEntityStatusPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityStatusMessage.class);
    }

    @Override
    public int getOutPlayEntityLeashPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, AttachEntityMessage.class);
    }

    @Override
    public int getOutPlayEntityMetadataPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityMetadataMessage.class);
    }

    @Override
    public int getOutPlayEntityEffectAddPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityEffectMessage.class);
    }

    @Override
    public int getOutPlayEntityEffectRemovePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityRemoveEffectMessage.class);
    }

    @Override
    public int getOutPlayExperiencePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ExperienceMessage.class);
    }

    @Override
    public int getOutPlayEntityAttributesPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, EntityPropertyMessage.class);
    }

    @Override
    public int getOutPlayChunkSinglePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ChunkDataMessage.class);
    }

    @Override
    public int getOutPlayBlockChangeMultiPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, MultiBlockChangeMessage.class);
    }

    @Override
    public int getOutPlayBlockChangeSinglePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, BlockChangeMessage.class);
    }

    @Override
    public int getOutPlayBlockActionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, BlockActionMessage.class);
    }

    @Override
    public int getOutPlayBlockBreakAnimationPacketId() {
        return 8;
    }

    @Override
    public int getOutPlayExplosionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ExplosionMessage.class);
    }

    @Override
    public int getOutPlayWorldEventPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PlayEffectMessage.class);
    }

    @Override
    public int getOutPlayWorldSoundPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SoundEffectMessage.class);
    }

    @Override
    public int getOutPlayWorldParticlesPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PlayParticleMessage.class);
    }

    @Override
    public int getOutPlayGameStateChangePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, StateChangeMessage.class);
    }

    @Override
    public int getOutPlaySpawnWeatherPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SpawnLightningStrikeMessage.class);
    }

    @Override
    public int getOutPlayWindowOpenPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, OpenWindowMessage.class);
    }

    @Override
    public int getOutPlayWindowClosePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, CloseWindowMessage.class);
    }

    @Override
    public int getOutPlayWindowSetSlotPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SetWindowSlotMessage.class);
    }

    @Override
    public int getOutPlayWindowSetItemsPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SetWindowContentsMessage.class);
    }

    @Override
    public int getOutPlayWindowDataPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, WindowPropertyMessage.class);
    }

    @Override
    public int getOutPlayWindowTransactionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, TransactionMessage.class);
    }

    @Override
    public int getOutPlayMapPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, MapDataMessage.class);
    }

    @Override
    public int getOutPlayUpdateTilePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, UpdateBlockEntityMessage.class);
    }

    @Override
    public int getOutPlaySignEditorPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SignEditorMessage.class);
    }

    @Override
    public int getOutPlayStatisticsPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, StatisticMessage.class);
    }

    @Override
    public int getOutPlayPlayerInfoPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, UserListItemMessage.class);
    }

    @Override
    public int getOutPlayAbilitiesPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PlayerAbilitiesMessage.class);
    }

    @Override
    public int getOutPlayTabCompletePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, TabCompleteResponseMessage.class);
    }

    @Override
    public int getOutPlayScoreboardObjectivePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ScoreboardObjectiveMessage.class);
    }

    @Override
    public int getOutPlayScoreboardScorePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ScoreboardScoreMessage.class);
    }

    @Override
    public int getOutPlayScoreboardDisplaySlotPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ScoreboardDisplayMessage.class);
    }

    @Override
    public int getOutPlayScoreboardTeamPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ScoreboardTeamMessage.class);
    }

    @Override
    public int getOutPlayCustomPayloadPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, PluginMessage.class);
    }

    @Override
    public int getOutPlayKickDisconnectPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, KickMessage.class);
    }

    @Override
    public int getOutPlayResourcePackPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ResourcePackSendMessage.class);
    }

    @Override
    public int getOutPlayCameraPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, CameraMessage.class);
    }

    @Override
    public int getOutPlayWorldBorderPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, WorldBorderMessage.class);
    }

    @Override
    public int getOutPlayTitlePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, TitleMessage.class);
    }

    @Override
    public int getOutPlayPlayerListHeaderFooterPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, UserListHeaderFooterMessage.class);
    }

    @Override
    public int getOutPlaySetPassengersPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SetPassengerMessage.class);
    }

    @Override
    public int getOutPlayChunkUnloadPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, UnloadChunkMessage.class);
    }

    @Override
    public int getOutPlayWorldCustomSoundPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, NamedSoundEffectMessage.class);
    }

    @Override
    public int getOutPlayServerDifficultyPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, ServerDifficultyMessage.class);
    }

    @Override
    public int getOutPlayCombatEventPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, CombatEventMessage.class);
    }

    @Override
    public int getOutPlayBossBarPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, BossBarMessage.class);
    }

    @Override
    public int getOutPlaySetCooldownPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, SetCooldownMessage.class);
    }

    @Override
    public int getOutPlayVehicleMovePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 1, VehicleMoveMessage.class);
    }

    @Override
    public int getInHandshakeStartPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.HANDSHAKE, 0, HandshakeMessage.class);
    }

    @Override
    public int getInStatusRequestPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.STATUS, 0, StatusRequestMessage.class);
    }

    @Override
    public int getInStatusPingPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.STATUS, 0, StatusPingMessage.class);
    }

    @Override
    public int getInLoginStartPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 0, LoginStartMessage.class);
    }

    @Override
    public int getInLoginEncryptionBeginPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.LOGIN, 0, EncryptionKeyResponseMessage.class);
    }

    @Override
    public int getInPlayKeepAlivePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PingMessage.class);
    }

    @Override
    public int getInPlayChatPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, IncomingChatMessage.class);
    }

    @Override
    public int getInPlayUseEntityPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, InteractEntityMessage.class);
    }

    @Override
    public int getInPlayPlayerPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerUpdateMessage.class);
    }

    @Override
    public int getInPlayPositionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerPositionMessage.class);
    }

    @Override
    public int getInPlayLookPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerLookMessage.class);
    }

    @Override
    public int getInPlayPositionLookPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerPositionLookMessage.class);
    }

    @Override
    public int getInPlayBlockDigPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, DiggingMessage.class);
    }

    @Override
    public int getInPlayBlockPlacePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, UseItemMessage.class);
    }

    @Override
    public int getInPlayHeldSlotPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, HeldItemMessage.class);
    }

    @Override
    public int getInPlayAnimationPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerSwingArmMessage.class);
    }

    @Override
    public int getInPlayEntityActionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerActionMessage.class);
    }

    @Override
    public int getInPlayMoveVehiclePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, VehicleMoveMessage.class);
    }

    @Override
    public int getInPlaySteerBoatPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, SteerVehicleMessage.class);
    }

    @Override
    public int getInPlaySteerVehiclePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, SteerVehicleMessage.class);
    }

    @Override
    public int getInPlayWindowClosePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, CloseWindowMessage.class);
    }

    @Override
    public int getInPlayWindowClickPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, WindowClickMessage.class);
    }

    @Override
    public int getInPlayWindowTransactionPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, TransactionMessage.class);
    }

    @Override
    public int getInPlayCreativeSetSlotPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, CreativeItemMessage.class);
    }

    @Override
    public int getInPlayEnchantSelectPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, EnchantItemMessage.class);
    }

    @Override
    public int getInPlayUpdateSignPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, UpdateSignMessage.class);
    }

    @Override
    public int getInPlayAbilitiesPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PlayerAbilitiesMessage.class);
    }

    @Override
    public int getInPlayTabCompletePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, TabCompleteMessage.class);
    }

    @Override
    public int getInPlaySettingsPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, ClientSettingsMessage.class);
    }

    @Override
    public int getInPlayClientCommandPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, ClientStatusMessage.class);
    }

    @Override
    public int getInPlayCustomPayloadPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, PluginMessage.class);
    }

    @Override
    public int getInPlayUseItemPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, BlockPlacementMessage.class);
    }

    @Override
    public int getInPlaySpectatePacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, SpectateMessage.class);
    }

    @Override
    public int getInPlayResourcePackStatusPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, ResourcePackStatusMessage.class);
    }

    @Override
    public int getInPlayTeleportAcceptPacketId() {
        return GlowStonePacketFactory.getOpcode(ProtocolType.PLAY, 0, TeleportConfirmMessage.class);
    }

    private static int getOpcode(ProtocolType protocolType, int direction, Class<? extends Message> messageClass) {
        try {
            GlowProtocol protocol = protocolType.getProtocol();
            Class<?> protocolClass = protocol.getClass();
            Field lookupServiceField = ReflectionUtils.getField(protocolClass, direction == 0 ? "inboundCodecs" : "outboundCodecs");
            lookupServiceField.setAccessible(true);
            CodecLookupService service = (CodecLookupService)lookupServiceField.get(protocol);
            Field messagesField = ReflectionUtils.getField(service.getClass(), "messages");
            messagesField.setAccessible(true);
            ConcurrentMap messageMap = (ConcurrentMap)messagesField.get(service);
            return ((Codec.CodecRegistration)messageMap.get(messageClass)).getOpcode();
        }
        catch (Throwable ignored) {
            throw new RuntimeException("Unable to get opcode");
        }
    }
}

