/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.utils.recyclable;

import io.netty.util.Recycler;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import protocolsupport.utils.recyclable.Recyclable;
import protocolsupport.utils.recyclable.RecyclableCollection;

public class RecyclableSingletonList<E>
extends AbstractCollection<E>
implements RecyclableCollection<E> {
    private static final Recycler<RecyclableSingletonList> RECYCLER = new Recycler<RecyclableSingletonList>(){

        protected RecyclableSingletonList newObject(Recycler.Handle handle) {
            return new RecyclableSingletonList(handle);
        }
    };
    private final Recycler.Handle handle;
    protected E singleValue;
    private final ResetableIterator iterator = new ResetableIterator();

    public static <T> RecyclableSingletonList<T> create(T singleValue) {
        RecyclableSingletonList list = (RecyclableSingletonList)RECYCLER.get();
        list.singleValue = singleValue;
        return list;
    }

    private RecyclableSingletonList(Recycler.Handle handle) {
        this.handle = handle;
    }

    @Override
    public void recycle() {
        if (this.singleValue instanceof Recyclable) {
            ((Recyclable)this.singleValue).recycle();
        }
        this.recycleObjectOnly();
    }

    @Override
    public void recycleObjectOnly() {
        this.singleValue = null;
        RECYCLER.recycle((Object)this, this.handle);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.singleValue.equals(o);
    }

    @Override
    public Iterator<E> iterator() {
        this.iterator.reset();
        return this.iterator;
    }

    protected class ResetableIterator
    implements Iterator<E> {
        private boolean hasNext = true;

        protected ResetableIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public E next() {
            if (this.hasNext) {
                this.hasNext = false;
                return RecyclableSingletonList.this.singleValue;
            }
            throw new NoSuchElementException();
        }

        public void reset() {
            this.hasNext = true;
        }
    }
}

