/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import protocolsupport.zplatform.itemstack.ItemStackWrapper;

public class MerchantData {
    private final int windowId;
    private final List<TradeOffer> offers = new ArrayList<TradeOffer>(10);

    public MerchantData(int windowId) {
        this.windowId = windowId;
    }

    public int getWindowId() {
        return this.windowId;
    }

    public void addOffer(TradeOffer offer) {
        this.offers.add(offer);
    }

    public List<TradeOffer> getOffers() {
        return Collections.unmodifiableList(this.offers);
    }

    public static class TradeOffer {
        private final ItemStackWrapper itemstack1;
        private final ItemStackWrapper itemstack2;
        private final ItemStackWrapper result;
        private final int uses;
        private final int maxuses;

        public TradeOffer(ItemStackWrapper itemstack1, ItemStackWrapper itemstack2, ItemStackWrapper result, int uses, int maxuses) {
            this.itemstack1 = itemstack1;
            this.result = result;
            this.uses = uses;
            this.maxuses = maxuses;
            this.itemstack2 = itemstack2;
        }

        public ItemStackWrapper getItemStack1() {
            return this.itemstack1;
        }

        public boolean hasItemStack2() {
            return !this.itemstack2.isNull();
        }

        public ItemStackWrapper getItemStack2() {
            return this.itemstack2;
        }

        public ItemStackWrapper getResult() {
            return this.result;
        }

        public boolean isDisabled() {
            return this.uses >= this.maxuses;
        }

        public int getUses() {
            return this.uses;
        }

        public int getMaxUses() {
            return this.maxuses;
        }
    }
}

