/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.typeskipper.id;

import java.util.HashSet;
import protocolsupport.libs.gnu.trove.map.hash.TIntByteHashMap;

public class SkippingTable {

    public static class GenericSkippingTable<T>
    extends SkippingTable {
        protected final HashSet<T> set = new HashSet();

        public void setSkip(T id) {
            this.set.add(id);
        }

        public boolean shouldSkip(T id) {
            return this.set.contains(id);
        }
    }

    public static class HashMapBasedIntSkippingTable
    extends IntSkippingTable {
        protected final TIntByteHashMap table = new TIntByteHashMap(16, 0.75f);

        @Override
        public void setSkip(int id) {
            this.table.put(id, (byte)1);
        }

        @Override
        public boolean shouldSkip(int id) {
            return this.table.containsKey(id);
        }
    }

    public static class ArrayBasedIntSkippingTable
    extends IntSkippingTable {
        protected final boolean[] table;

        public ArrayBasedIntSkippingTable(int size) {
            this.table = new boolean[size];
            for (int i = 0; i < this.table.length; ++i) {
                this.table[i] = false;
            }
        }

        @Override
        public void setSkip(int id) {
            this.table[id] = true;
        }

        @Override
        public boolean shouldSkip(int id) {
            return this.table[id];
        }
    }

    public static abstract class IntSkippingTable
    extends SkippingTable {
        public abstract void setSkip(int var1);

        public abstract boolean shouldSkip(int var1);
    }
}

