/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.server.ServerListPingEvent;
import org.bukkit.util.CachedServerIcon;
import protocolsupport.ProtocolSupport;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.ServerPingResponseEvent;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.utils.Utils;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public abstract class AbstractStatusListener {
    private static final int statusThreads = Utils.getJavaPropertyValue("statusthreads", 2, Utils.Converter.STRING_TO_INT);
    private static final int statusThreadKeepAlive = Utils.getJavaPropertyValue("statusthreadskeepalive", 60, Utils.Converter.STRING_TO_INT);
    private static final Executor statusprocessor = new ThreadPoolExecutor(1, statusThreads, (long)statusThreadKeepAlive, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> new Thread(r, "LoginProcessingThread"));
    protected final NetworkManagerWrapper networkManager;
    private boolean sentInfo = false;

    public static void init() {
        ProtocolSupport.logInfo("Login threads max count: " + statusThreads + ", keep alive time: " + statusThreadKeepAlive);
    }

    public AbstractStatusListener(NetworkManagerWrapper networkmanager) {
        this.networkManager = networkmanager;
    }

    public void handleStatusRequest() {
        if (this.sentInfo) {
            this.networkManager.close("Status request has already been handled.");
        }
        this.sentInfo = true;
        statusprocessor.execute(() -> {
            InetSocketAddress addr = this.networkManager.getAddress();
            ArrayList<Player> players = new ArrayList<Player>(Bukkit.getOnlinePlayers());
            String motd = Bukkit.getMotd();
            int maxPlayers = Bukkit.getMaxPlayers();
            InternalServerListPingEvent bevent = new InternalServerListPingEvent(addr.getAddress(), motd, maxPlayers, players);
            bevent.setServerIcon(Bukkit.getServerIcon());
            Bukkit.getPluginManager().callEvent((Event)bevent);
            String icon = bevent.getIcon() != null ? ServerPlatform.get().getMiscUtils().convertBukkitIconToBase64(bevent.getIcon()) : null;
            motd = bevent.getMotd();
            maxPlayers = bevent.getMaxPlayers();
            ArrayList<String> profiles = new ArrayList<String>(players.size());
            for (Player player : players) {
                profiles.add(player.getName());
            }
            ServerPingResponseEvent revent = new ServerPingResponseEvent(ConnectionImpl.getFromChannel(this.networkManager.getChannel()), new ServerPingResponseEvent.ProtocolInfo(ProtocolVersion.getLatest(), ServerPlatform.get().getMiscUtils().getModName() + " " + ServerPlatform.get().getMiscUtils().getVersionName()), icon, motd, maxPlayers, profiles);
            Bukkit.getPluginManager().callEvent((Event)revent);
            this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createStausServerInfoPacket(revent.getPlayers(), revent.getProtocolInfo(), revent.getIcon(), revent.getMotd(), revent.getMaxPlayers()));
        });
    }

    public void handlePing(long pingId) {
        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createStatusPongPacket(pingId), (GenericFutureListener<? extends Future<? super Void>>)ChannelFutureListener.CLOSE, new GenericFutureListener[0]);
    }

    public static class InternalServerListPingEvent
    extends ServerListPingEvent {
        private final List<Player> players;
        protected CachedServerIcon icon;

        protected InternalServerListPingEvent(InetAddress address, String motd, int maxPlayers, List<Player> players) {
            super(address, motd, maxPlayers);
            this.players = players;
        }

        public CachedServerIcon getIcon() {
            return this.icon;
        }

        public void setServerIcon(CachedServerIcon icon) {
            this.icon = icon;
        }

        public Iterator<Player> iterator() throws UnsupportedOperationException {
            return this.players.iterator();
        }
    }
}

