/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.handler;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import protocolsupport.api.Connection;
import protocolsupport.api.ProtocolVersion;
import protocolsupport.api.events.ConnectionHandshakeEvent;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.libs.com.google.gson.Gson;
import protocolsupport.protocol.ConnectionImpl;
import protocolsupport.protocol.packet.handler.AbstractLoginListener;
import protocolsupport.protocol.packet.handler.AbstractStatusListener;
import protocolsupport.protocol.storage.ThrottleTracker;
import protocolsupport.protocol.utils.authlib.UUIDTypeAdapter;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public abstract class AbstractHandshakeListener {
    private static final Gson gson = new Gson();
    protected final NetworkManagerWrapper networkManager;

    protected AbstractHandshakeListener(NetworkManagerWrapper networkmanager) {
        this.networkManager = networkmanager;
    }

    public void handleSetProtocol(int clientVersion, NetworkState nextState, String hostname, int port) {
        switch (nextState) {
            case LOGIN: {
                this.networkManager.setProtocol(NetworkState.LOGIN);
                try {
                    InetAddress address = this.networkManager.getAddress().getAddress();
                    if (ThrottleTracker.isEnabled() && !ServerPlatform.get().getMiscUtils().isBungeeEnabled() && ThrottleTracker.throttle(address)) {
                        final String message = "Connection throttled! Please wait before reconnecting.";
                        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginDisconnectPacket(message), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                            public void operationComplete(Future<? super Void> arg0) {
                                AbstractHandshakeListener.this.networkManager.close(message);
                            }
                        }, new GenericFutureListener[0]);
                        return;
                    }
                }
                catch (Throwable t) {
                    Bukkit.getLogger().log(Level.WARNING, "Failed to check connection throttle", t);
                }
                ProtocolVersion clientversion = ProtocolVersion.fromId(clientVersion);
                if (clientversion != ProtocolVersion.getLatest()) {
                    final String message = MessageFormat.format(ServerPlatform.get().getMiscUtils().getOutdatedServerMessage().replace("'", "''"), ServerPlatform.get().getMiscUtils().getVersionName());
                    this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginDisconnectPacket(message), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                        public void operationComplete(Future<? super Void> arg0) {
                            AbstractHandshakeListener.this.networkManager.close(message);
                        }
                    }, new GenericFutureListener[0]);
                    break;
                }
                ConnectionImpl connection = ConnectionImpl.getFromChannel(this.networkManager.getChannel());
                if (ServerPlatform.get().getMiscUtils().isBungeeEnabled()) {
                    String[] split = hostname.split("\u0000");
                    if (split.length != 3 && split.length != 4) {
                        final String message = "If you wish to use IP forwarding, please enable it in your BungeeCord config as well!";
                        this.networkManager.sendPacket(ServerPlatform.get().getPacketFactory().createLoginDisconnectPacket(message), (GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<Future<? super Void>>(){

                            public void operationComplete(Future<? super Void> arg0) {
                                AbstractHandshakeListener.this.networkManager.close(message);
                            }
                        }, new GenericFutureListener[0]);
                        return;
                    }
                    hostname = split[0];
                    connection.changeAddress(new InetSocketAddress(split[1], connection.getAddress().getPort()));
                    this.networkManager.setSpoofedProfile(UUIDTypeAdapter.fromString(split[2]), split.length == 4 ? gson.fromJson(split[3], PlayerPropertiesResolveEvent.ProfileProperty[].class) : null);
                }
                ConnectionHandshakeEvent event = new ConnectionHandshakeEvent((Connection)connection, hostname);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.getSpoofedAddress() != null) {
                    connection.changeAddress(event.getSpoofedAddress());
                }
                this.networkManager.setPacketListener(this.getLoginListener(this.networkManager, hostname + ":" + port));
                break;
            }
            case STATUS: {
                this.networkManager.setProtocol(NetworkState.STATUS);
                this.networkManager.setPacketListener(this.getStatusListener(this.networkManager));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Invalid intention " + (Object)((Object)nextState));
            }
        }
    }

    protected abstract AbstractLoginListener getLoginListener(NetworkManagerWrapper var1, String var2);

    protected abstract AbstractStatusListener getStatusListener(NetworkManagerWrapper var1);
}

