/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.chat.modifiers;

import java.util.UUID;
import org.bukkit.Achievement;
import org.bukkit.Statistic;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import protocolsupport.api.chat.ChatAPI;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.utils.Any;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.itemstack.NBTTagCompoundWrapper;

public class HoverAction {
    private final Type type;
    private final String value;

    public HoverAction(Type type, String value) {
        this.type = type;
        this.value = value;
    }

    public HoverAction(BaseComponent component) {
        this.type = Type.SHOW_TEXT;
        this.value = ChatAPI.toJSON(component);
    }

    public HoverAction(ItemStack itemstack) {
        this.type = Type.SHOW_ITEM;
        this.value = ServerPlatform.get().getMiscUtils().createNBTTagFromItemStack(itemstack).toString();
    }

    public HoverAction(Entity entity) {
        this(new EntityInfo(entity));
    }

    public HoverAction(EntityInfo entityinfo) {
        this.type = Type.SHOW_ENTITY;
        NBTTagCompoundWrapper compound = ServerPlatform.get().getWrapperFactory().createEmptyNBTCompound();
        compound.setString("type", entityinfo.getType().getName());
        compound.setString("id", entityinfo.getUUID().toString());
        compound.setString("name", entityinfo.getName());
        this.value = compound.toString();
    }

    public HoverAction(Achievement achievment) {
        this.type = Type.SHOW_ACHIEVEMENT;
        this.value = ServerPlatform.get().getMiscUtils().getAchievmentName(achievment);
    }

    public HoverAction(Statistic stat) {
        this.type = Type.SHOW_ACHIEVEMENT;
        this.value = ServerPlatform.get().getMiscUtils().getStatisticName(stat);
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public BaseComponent getText() {
        HoverAction.validateAction(this.type, Type.SHOW_TEXT);
        return ChatAPI.fromJSON(this.value);
    }

    public ItemStack getItemStack() {
        HoverAction.validateAction(this.type, Type.SHOW_ITEM);
        return ServerPlatform.get().getMiscUtils().createItemStackFromNBTTag(ServerPlatform.get().getWrapperFactory().createNBTCompoundFromJson(this.value));
    }

    public EntityInfo getEntity() {
        HoverAction.validateAction(this.type, Type.SHOW_ENTITY);
        NBTTagCompoundWrapper compound = ServerPlatform.get().getWrapperFactory().createNBTCompoundFromJson(this.value);
        return new EntityInfo(EntityType.fromName((String)compound.getString("type")), UUID.fromString(compound.getString("id")), compound.getString("name"));
    }

    public Any<Achievement, Statistic> getAchievmentOrStat() {
        HoverAction.validateAction(this.type, Type.SHOW_ACHIEVEMENT);
        Achievement achievement = ServerPlatform.get().getMiscUtils().getAchievmentByName(this.value);
        Statistic stat = ServerPlatform.get().getMiscUtils().getStatisticByName(this.value);
        return new Any<Achievement, Statistic>(achievement, stat);
    }

    static void validateAction(Type current, Type expected) {
        if (current != expected) {
            throw new IllegalStateException((Object)((Object)current) + " is not an " + (Object)((Object)expected));
        }
    }

    public static class EntityInfo {
        private final EntityType etype;
        private final UUID uuid;
        private final String name;

        public EntityInfo(EntityType etype, UUID uuid, String name) {
            this.etype = etype;
            this.uuid = uuid;
            this.name = name;
        }

        public EntityInfo(Entity entity) {
            this(entity.getType(), entity.getUniqueId(), entity.getName());
        }

        public EntityType getType() {
            return this.etype;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum Type {
        SHOW_TEXT,
        SHOW_ACHIEVEMENT,
        SHOW_ITEM,
        SHOW_ENTITY;

    }
}

