/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal.data;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.MarriagePlugin;
import com.lenis0012.bukkit.marriage2.internal.data.DBUpgrade;
import com.lenis0012.bukkit.marriage2.internal.data.Driver;
import com.lenis0012.bukkit.marriage2.internal.data.MarriageData;
import com.lenis0012.bukkit.marriage2.internal.data.MarriagePlayer;
import com.lenis0012.bukkit.marriage2.misc.BConfig;
import com.lenis0012.bukkit.marriage2.misc.ListQuery;
import com.lenis0012.bukkit.marriage2.misc.LockedReference;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class DataManager {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Cache<UUID, MarriageData> marriageDataCache = CacheBuilder.newBuilder().expireAfterWrite(60L, TimeUnit.SECONDS).build();
    private final MarriageCore core;
    private LockedReference<Connection> supplier;
    private String prefix;

    public static ExecutorService getExecutorService() {
        return executorService;
    }

    public DataManager(MarriageCore core) {
        BConfig config;
        this.core = core;
        File configFile = new File(core.getPlugin().getDataFolder(), "database-settings.yml");
        if (!configFile.exists()) {
            BConfig.copyFile(core.getPlugin().getResource("database-settings.yml"), configFile);
        }
        Driver driver = (config = core.getBukkitConfig("database-settings.yml")).getBoolean("MySQL.enabled") ? Driver.MYSQL : Driver.SQLITE;
        this.loadWithDriver(driver, (FileConfiguration)config);
    }

    public DataManager(MarriageCore core, Driver driver) {
        this.core = core;
        BConfig config = core.getBukkitConfig("database-settings.yml");
        this.loadWithDriver(driver, (FileConfiguration)config);
    }

    public void close() {
        this.supplier.invalidateNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadWithDriver(Driver driver, FileConfiguration config) {
        String url;
        if (driver == Driver.MYSQL) {
            String user = config.getString("MySQL.user", "root");
            String pswd = config.getString("MySQL.password", "");
            String host = config.getString("MySQL.host", "localhost:3306");
            String database = config.getString("MySQL.database", "myserver");
            this.prefix = config.getString("MySQL.prefix", "marriage_");
            url = String.format("jdbc:mysql://%s/%s?user=%s&password=%s", host, database, user, pswd);
            driver = Driver.MYSQL;
        } else {
            url = String.format("jdbc:sqlite:%s", new File(this.core.getPlugin().getDataFolder(), "database.db").getPath());
            this.prefix = "";
        }
        if (config.getBoolean("auto-purge.enabled")) {
            long delayTime = 72000L;
            int days = config.getInt("auto-purge.purge-after-days", 45);
            final boolean purgeMarried = config.getBoolean("auto-purge.purge-married-players", false);
            final long daysInMillis = (long)(days * 24 * 60 * 60) * 1000L;
            Bukkit.getScheduler().runTaskTimerAsynchronously(MarriagePlugin.getCore().getPlugin(), new Runnable(){

                @Override
                public void run() {
                    long startTime = System.currentTimeMillis();
                    int purged = DataManager.this.purge(daysInMillis, purgeMarried);
                    long duration = System.currentTimeMillis() - startTime;
                    DataManager.this.core.getLogger().log(Level.INFO, "Purged " + purged + " player entried in " + duration + "ms");
                }
            }, 0L, 72000L);
        }
        try {
            driver.initiate();
        }
        catch (Exception e) {
            this.core.getLogger().log(Level.SEVERE, "Failed to initiate database driver", e);
        }
        this.supplier = new LockedReference<Connection>(new ConnectionSupplier(url), 30L, TimeUnit.SECONDS, new ConnectionInvalidator());
        DBUpgrade upgrade = new DBUpgrade();
        Connection connection = this.supplier.access();
        try {
            Statement statement = connection.createStatement();
            driver.runSetup(statement, this.prefix);
            ResultSet result = statement.executeQuery(String.format("SELECT * FROM %sversion;", this.prefix));
            if (result.next()) {
                DatabaseMetaData metadata;
                ResultSet res;
                int dbVersion = result.getInt("version_id");
                if (dbVersion >= 2 && !(res = (metadata = connection.getMetaData()).getColumns(null, null, this.prefix + "players", "last_name")).next()) {
                    statement.execute("ALTER TABLE " + this.prefix + "players ADD last_name VARCHAR(16);");
                }
                if (dbVersion < upgrade.getVersionId()) {
                    upgrade.run(statement, dbVersion, this.prefix);
                    PreparedStatement ps = connection.prepareStatement("UPDATE " + this.prefix + "version SET version_id=? WHERE version_id=?;");
                    ps.setInt(1, upgrade.getVersionId());
                    ps.setInt(2, dbVersion);
                    ps.executeUpdate();
                }
            } else {
                statement.executeUpdate(String.format("INSERT INTO %sversion (version_id) VALUES(%s);", this.prefix, upgrade.getVersionId()));
            }
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to initiate database", e);
        }
        finally {
            this.supplier.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int purge(long daysInMillis, boolean purgeMarried) {
        String query = String.format("SELECT * FROM %splayers WHERE lastlogin < ?;", this.prefix);
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, System.currentTimeMillis() - daysInMillis);
            ResultSet result = ps.executeQuery();
            HashSet removeList = Sets.newHashSet();
            HashSet removeList2 = Sets.newHashSet();
            while (result.next()) {
                removeList.add(result.getString("unique_user_id"));
            }
            ps.close();
            this.supplier.finish();
            if (!purgeMarried) {
                connection = this.supplier.access();
                ps = connection.prepareStatement("SELECT * FROM " + this.prefix + "marriages;");
                result = ps.executeQuery();
                while (result.next()) {
                    boolean remove = removeList.remove(result.getString("player1"));
                    remove = remove || removeList.remove(result.getString("player2"));
                    if (!remove) continue;
                    removeList2.add(result.getInt("id"));
                }
                ps.close();
                this.supplier.finish();
            }
            connection = this.supplier.access();
            ps = connection.prepareStatement("DELETE FROM " + this.prefix + "players WHERE unique_user_id=?;");
            for (String uuid : removeList) {
                ps.setString(1, uuid);
                ps.addBatch();
            }
            ps.executeBatch();
            ps.close();
            this.supplier.finish();
            connection = this.supplier.access();
            ps = connection.prepareStatement("DELETE FROM " + this.prefix + "marriages WHERE id=?;");
            Iterator iterator = removeList2.iterator();
            while (iterator.hasNext()) {
                int id = (Integer)iterator.next();
                ps.setInt(1, id);
                ps.addBatch();
            }
            ps.executeBatch();
            ps.close();
            int n = removeList.size();
            return n;
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to purge user data", e);
            int n = 0;
            return n;
        }
        finally {
            this.supplier.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarriagePlayer loadPlayer(UUID uuid) {
        MarriagePlayer player = null;
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement(String.format("SELECT * FROM %splayers WHERE unique_user_id=?;", this.prefix));
            ps.setString(1, uuid.toString());
            player = new MarriagePlayer(uuid, ps.executeQuery());
            ps.close();
            this.loadMarriages(connection, player, false);
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to load player data", e);
        }
        finally {
            this.supplier.finish();
        }
        return player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePlayer(MarriagePlayer player) {
        if (player == null || player.getUniqueId() == null) {
            return;
        }
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement(String.format("SELECT * FROM %splayers WHERE unique_user_id=?;", this.prefix));
            ps.setString(1, player.getUniqueId().toString());
            ResultSet result = ps.executeQuery();
            if (result.next()) {
                PreparedStatement ps2 = connection.prepareStatement(String.format("UPDATE %splayers SET last_name=?,gender=?,priest=?,lastlogin=? WHERE unique_user_id=?;", this.prefix));
                ps2.setString(1, player.getLastName());
                ps2.setString(2, player.getGender().toString());
                ps2.setBoolean(3, player.isPriest());
                ps2.setLong(4, System.currentTimeMillis());
                ps2.setString(5, player.getUniqueId().toString());
                ps2.executeUpdate();
                ps2.close();
            } else {
                PreparedStatement ps2 = connection.prepareStatement(String.format("INSERT INTO %splayers (unique_user_id,last_name,gender,priest,lastlogin) VALUES(?,?,?,?,?);", this.prefix));
                player.save(ps2);
                ps2.executeUpdate();
                ps2.close();
            }
            ps.close();
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to save player data", e);
        }
        finally {
            this.supplier.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveMarriage(MarriageData mdata) {
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement(String.format("SELECT * FROM %smarriages WHERE player1=? AND player2=?;", this.prefix));
            ps.setString(1, mdata.getPlayer1Id().toString());
            ps.setString(2, mdata.getPllayer2Id().toString());
            ResultSet result = ps.executeQuery();
            if (result.next()) {
                PreparedStatement ps2 = connection.prepareStatement(String.format("UPDATE %smarriages SET player1=?,player2=?,home_world=?,home_x=?,home_y=?,home_z=?,home_yaw=?,home_pitch=?,pvp_enabled=? WHERE id=?;", this.prefix));
                mdata.save(ps2);
                ps2.setInt(10, mdata.getId());
                ps2.executeUpdate();
                ps2.close();
            } else {
                PreparedStatement ps2 = connection.prepareStatement(String.format("INSERT INTO %smarriages (player1,player2,home_world,home_x,home_y,home_z,home_yaw,home_pitch,pvp_enabled) VALUES(?,?,?,?,?,?,?,?,?);", this.prefix));
                mdata.save(ps2);
                ps2.executeUpdate();
                ps2.close();
            }
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to save marriage data", e);
        }
        finally {
            this.supplier.finish();
        }
    }

    private void loadMarriages(Connection connection, MarriagePlayer player, boolean alt) throws SQLException {
        PreparedStatement ps = connection.prepareStatement(String.format("SELECT * FROM %smarriages WHERE %s=?;", this.prefix, alt ? "player2" : "player1", this.prefix));
        ps.setString(1, player.getUniqueId().toString());
        ResultSet result = ps.executeQuery();
        while (result.next()) {
            MarriageData data;
            UUID partnerId = UUID.fromString(result.getString(alt ? "player1" : "player2"));
            Player partner = Bukkit.getPlayer((UUID)partnerId);
            if (partner != null && partner.isOnline() && this.core.isMPlayerSet(partner.getUniqueId())) {
                data = (MarriageData)this.core.getMPlayer(partnerId).getMarriage();
            } else {
                data = (MarriageData)this.marriageDataCache.getIfPresent((Object)player.getUniqueId());
                if (data == null) {
                    data = new MarriageData(this, result);
                    this.marriageDataCache.put((Object)data.getPlayer1Id(), (Object)data);
                    this.marriageDataCache.put((Object)data.getPllayer2Id(), (Object)data);
                }
            }
            player.addMarriage(data);
        }
        ps.close();
        if (!alt) {
            this.loadMarriages(connection, player, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteMarriage(UUID player1, UUID player2) {
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement(String.format("DELETE FROM %smarriages WHERE player1=? AND player2=?;", this.prefix));
            ps.setString(1, player1.toString());
            ps.setString(2, player2.toString());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to load player data", e);
        }
        finally {
            this.supplier.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListQuery listMarriages(int scale, int page) {
        Connection connection = this.supplier.access();
        try {
            PreparedStatement ps = connection.prepareStatement("SELECT COUNT(*) FROM " + this.prefix + "marriages;");
            ResultSet result = ps.executeQuery();
            result.next();
            int pages = (int)Math.ceil((double)result.getInt(1) / (double)scale);
            ps = connection.prepareStatement(String.format("SELECT * FROM %smarriages LIMIT %s OFFSET %s;", this.prefix, scale, scale * page));
            result = ps.executeQuery();
            ArrayList list = Lists.newArrayList();
            while (result.next()) {
                list.add(new MarriageData(this, result));
            }
            ps.close();
            ListQuery listQuery = new ListQuery(this, pages, page, list);
            return listQuery;
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to load marriage list", e);
            ListQuery listQuery = new ListQuery(this, 0, 0, new ArrayList<MData>());
            return listQuery;
        }
        finally {
            this.supplier.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean migrateTo(DataManager db, boolean migrateUnmarriedPlayers) {
        Connection connection = this.supplier.access();
        try {
            this.core.getLogger().log(Level.INFO, "Migrating player data... (may take A WHILE)");
            PreparedStatement ps = connection.prepareStatement("SELECT * FROM " + this.prefix + "players;");
            ResultSet result = ps.executeQuery();
            while (result.next()) {
                UUID uuid = UUID.fromString(result.getString("unique_user_id"));
                MarriagePlayer player = new MarriagePlayer(uuid, result);
                if (!player.isMarried() && !migrateUnmarriedPlayers) continue;
                db.savePlayer(player);
            }
            ps.close();
            this.core.getLogger().log(Level.INFO, "Migrating marriage data...");
            ps = connection.prepareStatement("SELECT * FROM " + this.prefix + "marriages;");
            result = ps.executeQuery();
            while (result.next()) {
                MarriageData data = new MarriageData(this, result);
                db.saveMarriage(data);
            }
            ps.close();
            this.core.getLogger().log(Level.INFO, "Migration complete!");
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            this.core.getLogger().log(Level.WARNING, "Failed to load migrate database", e);
        }
        finally {
            this.supplier.finish();
        }
        return false;
    }

    private static final class ConnectionInvalidator
    implements Consumer<Connection> {
        private ConnectionInvalidator() {
        }

        @Override
        public void accept(Connection connection) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private static final class ConnectionSupplier
    implements Supplier<Connection> {
        private final String url;

        private ConnectionSupplier(String url) {
            this.url = url;
        }

        @Override
        public Connection get() {
            try {
                return DriverManager.getConnection(this.url);
            }
            catch (SQLException e) {
                return null;
            }
        }
    }
}

