/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal.data;

import com.google.common.collect.Maps;
import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.internal.data.MarriagePlayer;
import com.lenis0012.bukkit.marriage2.misc.UUIDFetcher;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.configuration.file.YamlConfiguration;

public class DataConverter {
    private final MarriageCore core;
    private File dir;

    public DataConverter(MarriageCore core) {
        this.core = core;
    }

    public boolean isOutdated() {
        this.dir = new File(this.core.getPlugin().getDataFolder(), "playerdata");
        return this.dir.exists();
    }

    public void convert() {
        double progress;
        int completed;
        long lastMessage = 0L;
        File[] files = this.dir.listFiles();
        int totalFiles = files.length;
        this.core.getLogger().log(Level.INFO, "Converting " + totalFiles + " old database entries...");
        HashMap uuidMap = Maps.newHashMap();
        UUIDFetcher uuidFetcher = new UUIDFetcher(new ArrayList<String>());
        int ranThroughMojang = 0;
        int failed = 0;
        for (completed = 0; completed < totalFiles; ++completed) {
            UUID userId;
            OfflinePlayer offlinePlayer;
            File file = files[completed];
            String string = file.getName().replace(".yml", "");
            progress = ((double)completed + 1.0) / (double)totalFiles;
            if (System.currentTimeMillis() >= lastMessage) {
                lastMessage = System.currentTimeMillis() + 2500L;
                this.reportStatus(progress);
            }
            if ((offlinePlayer = Bukkit.getOfflinePlayer((String)string)) != null && (userId = offlinePlayer.getUniqueId()) != null) {
                uuidMap.put(string, userId);
                continue;
            }
            if (ranThroughMojang >= 50000) {
                ++failed;
                continue;
            }
            uuidFetcher.addName(string);
            ++ranThroughMojang;
            if (uuidFetcher.size() != 100) continue;
            try {
                uuidMap.putAll(uuidFetcher.call());
            }
            catch (Exception e) {
                this.core.getLogger().log(Level.WARNING, "Failed to retrieve UUID for 100 players!");
            }
            uuidFetcher = new UUIDFetcher(new ArrayList<String>());
        }
        this.core.getLogger().log(Level.INFO, String.format("Converted %s entries. %s locally, %s through mojang, %s failed.", totalFiles, totalFiles - ranThroughMojang - failed, ranThroughMojang, failed));
        this.core.getLogger().log(Level.INFO, "Failed entries are likely from inactive players.");
        this.core.getLogger().log(Level.INFO, "Inserting user data into new database...");
        completed = 0;
        for (Map.Entry entry : uuidMap.entrySet()) {
            try {
                UUID uuid;
                MarriagePlayer mp = this.core.getDataManager().loadPlayer((UUID)entry.getValue());
                String name = (String)entry.getKey();
                mp.setLastName(name);
                File file = new File(this.dir, name + ".yml");
                YamlConfiguration cnf = YamlConfiguration.loadConfiguration((File)file);
                cnf.load(file);
                if (cnf.contains("partner") && !mp.isMarried() && (uuid = (UUID)uuidMap.get(cnf.getString("partner"))) != null) {
                    World world;
                    MarriagePlayer mp2 = this.core.getDataManager().loadPlayer(uuid);
                    MData mdata = this.core.marry(mp, mp2);
                    if (cnf.contains("home") && (world = Bukkit.getWorld((String)cnf.getString("home.world"))) != null) {
                        double x = cnf.getDouble("home.x", 0.0);
                        double y = cnf.getDouble("home.y", 0.0);
                        double z = cnf.getDouble("home.z", 0.0);
                        float yaw = (float)cnf.getDouble("home.yaw", 0.0);
                        float pitch = (float)cnf.getDouble("home.pitch", 0.0);
                        Location location = new Location(world, x, y, z, yaw, pitch);
                        mdata.setHome(location);
                    }
                    this.core.getDataManager().savePlayer(mp);
                    this.core.getDataManager().savePlayer(mp2);
                }
            }
            catch (Exception e) {
                this.core.getLogger().log(Level.WARNING, "Failed to convert data for player " + (String)entry.getKey(), e);
            }
            progress = (double)(++completed) / (double)uuidMap.size();
            if (System.currentTimeMillis() < lastMessage) continue;
            lastMessage = System.currentTimeMillis() + 2500L;
            this.reportStatus(progress);
        }
        this.core.getLogger().log(Level.INFO, "Renaming playerdata file...");
        int remainingTries = 60;
        while (!this.dir.renameTo(new File(this.core.getPlugin().getDataFolder(), "playerdata_backup"))) {
            long sleepTime = 500L;
            if (remainingTries-- <= 0) {
                this.core.getLogger().log(Level.WARNING, "Failed to rename old playerdata file, please do manually!");
                this.core.getLogger().log(Level.INFO, "Server starting normally in 10 seconds.");
                sleepTime = 10000L;
            }
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void reportStatus(double progress) {
        int i;
        int percent = (int)Math.floor(progress * 100.0);
        StringBuilder bar = new StringBuilder("[");
        for (i = 0; i < percent; i += 5) {
            bar.append('=');
        }
        for (i = percent; i < 100; i += 5) {
            bar.append('_');
        }
        bar.append("] (").append(percent).append("%)");
        this.core.getLogger().log(Level.INFO, bar.toString());
    }
}

