/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.landMap.LandMap;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ShowMap
implements LandlordCommand {
    private Landlord plugin;

    public ShowMap(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!this.plugin.getConfig().getBoolean("options.enableMap", true)) {
            sender.sendMessage(ChatColor.YELLOW + "La carte est d\u00e9sactiv\u00e9e.");
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(ChatColor.DARK_RED + "Cette commande peut \u00eatre ex\u00e9cut\u00e9e seulement par un joueur.");
        } else {
            Player player = (Player)sender;
            if (!player.hasPermission("landlord.player.map")) {
                player.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
                return true;
            }
            LandMap.displayMap(player);
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.player.map") || !this.plugin.getConfig().getBoolean("options.enableMap", true)) {
            return null;
        }
        String usage = "/#{label} #{cmd}";
        String desc = "Affiche/Cache la carte des terrains.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"map"};
    }
}

