/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.delays;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class Delay {
    private String name = "";
    private final HashMap<Channel, Integer> delays = new HashMap();
    private final HashMap<Channel, BukkitTask> timers = new HashMap();

    public Delay(String name) {
        this.name = name.toLowerCase();
    }

    public void addDelay(final Channel c) {
        this.removeDelay(c);
        this.delays.put(c, c.getDelayPerMessage());
        this.timers.put(c, Bukkit.getScheduler().runTaskTimer(Bukkit.getPluginManager().getPlugin("Legendchat"), new Runnable(){

            @Override
            public void run() {
                if (Delay.this.hasDelay(c)) {
                    int delay = Delay.this.getDelay(c);
                    if (delay > 0) {
                        Delay.this.delays.remove(c);
                        Delay.this.delays.put(c, delay - 1);
                    } else {
                        Delay.this.removeDelay(c);
                    }
                }
            }
        }, 20L, 20L));
    }

    public void removeDelay(Channel c) {
        if (this.hasDelay(c)) {
            this.timers.get(c).cancel();
            this.timers.remove(c);
            this.delays.remove(c);
            if (this.delays.isEmpty()) {
                Legendchat.getDelayManager().removePlayerDelay(this.name);
            }
        }
    }

    public boolean hasDelay(Channel c) {
        return this.delays.containsKey(c);
    }

    public int getDelay(Channel c) {
        if (this.hasDelay(c)) {
            return this.delays.get(c);
        }
        return 0;
    }

    public String getPlayerName() {
        return this.name;
    }

    public int getDelaysSize() {
        return this.delays.size();
    }

    public List<Channel> getDelayedChannels() {
        ArrayList<Channel> c = new ArrayList<Channel>();
        c.addAll(this.delays.keySet());
        return c;
    }
}

