/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.channels.types;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.api.events.BungeecordChatMessageEvent;
import br.com.devpaulo.legendchat.channels.types.Channel;
import br.com.devpaulo.legendchat.channels.utils.ChannelUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class BungeecordChannel
implements Channel {
    private String name = "";
    private String nick = "";
    private String format = "";
    private String color = "";
    private String color2 = "";
    private boolean shortcut = false;
    private boolean focus = false;
    private double distance = 0.0;
    private boolean crossworlds = false;
    private double cost = 0.0;
    private boolean show_cost_msg = false;
    private int delay = 0;

    public BungeecordChannel(String name, String nick, String format, String color, boolean shortcut, boolean focus, double distance, boolean crossworlds, int delay, double cost, boolean show_cost_msg) {
        this.name = name;
        this.nick = nick;
        this.format = format;
        this.color = ChannelUtils.translateStringColor(color);
        this.color2 = color.toLowerCase();
        this.shortcut = shortcut;
        this.focus = focus;
        this.distance = distance;
        this.crossworlds = crossworlds;
        this.cost = cost;
        this.show_cost_msg = show_cost_msg;
        this.delay = delay;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNickname() {
        return this.nick;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public String getColor() {
        return this.color;
    }

    @Override
    public String getStringColor() {
        return this.color2;
    }

    @Override
    public boolean isShortcutAllowed() {
        return this.shortcut;
    }

    @Override
    public boolean isFocusNeeded() {
        return this.focus;
    }

    @Override
    public boolean isCrossworlds() {
        return this.crossworlds;
    }

    @Override
    public double getMaxDistance() {
        return this.distance;
    }

    @Override
    public double getMessageCost() {
        return this.cost;
    }

    @Override
    public double getCostPerMessage() {
        return this.cost;
    }

    @Override
    public boolean showCostMessage() {
        return this.show_cost_msg;
    }

    @Override
    public int getDelayPerMessage() {
        return this.delay;
    }

    @Override
    public List<Player> getPlayersFocusedInChannel() {
        return Legendchat.getPlayerManager().getPlayersFocusedInChannel(this);
    }

    @Override
    public List<Player> getPlayersWhoCanSeeChannel() {
        return Legendchat.getPlayerManager().getPlayersWhoCanSeeChannel(this);
    }

    @Override
    public void sendMessage(String message) {
        ChannelUtils.otherMessage(this, message);
    }

    @Override
    public void sendMessage(Player sender, String message) {
        ChannelUtils.fakeMessage(this, sender, message);
    }

    @Override
    public void sendMessage(Player sender, String message, String bukkit_format, boolean cancelled) {
        ChannelUtils.realMessage(this, sender, message, bukkit_format, cancelled);
    }

    public void sendBungeecordMessage(HashMap<String, String> tags, String message) {
        HashSet<Player> recipients = new HashSet<Player>();
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("legendchat.channel." + this.getName().toLowerCase() + ".chat") && !p.hasPermission("legendchat.admin")) continue;
            recipients.add(p);
        }
        BungeecordChatMessageEvent e = new BungeecordChatMessageEvent(this, message, Legendchat.format(this.getFormat()), this.getFormat(), recipients, tags, false);
        Bukkit.getPluginManager().callEvent((Event)e);
        if (e.isCancelled()) {
            return;
        }
        String completa = e.getFormat();
        if (Legendchat.blockRepeatedTags()) {
            if (e.getTags().contains("prefix") && e.getTags().contains("groupprefix") && e.getTagValue("prefix").equals(e.getTagValue("groupprefix"))) {
                e.setTagValue("prefix", "");
            }
            if (e.getTags().contains("suffix") && e.getTags().contains("groupsuffix") && e.getTagValue("suffix").equals(e.getTagValue("groupsuffix"))) {
                e.setTagValue("suffix", "");
            }
        }
        for (String n : e.getTags()) {
            completa = completa.replace("{" + n + "}", ChatColor.translateAlternateColorCodes((char)'&', (String)e.getTagValue(n)));
        }
        completa = completa.replace("{msg}", message);
        for (Player p : e.getRecipients()) {
            p.sendMessage(completa);
        }
        if (Legendchat.logToBukkit()) {
            Bukkit.getConsoleSender().sendMessage(completa);
        }
    }

    @Override
    public void setNickname(String n) {
        this.nick = n;
    }

    @Override
    public void setFormat(String n) {
        this.format = n;
    }

    @Override
    public void setColor(ChatColor c) {
        this.color2 = ChannelUtils.translateChatColorToStringColor(c);
        this.color = ChannelUtils.translateStringColor(this.color2);
    }

    @Override
    public void setShortcutAllowed(boolean n) {
        this.shortcut = n;
    }

    @Override
    public void setFocusNeeded(boolean n) {
        this.focus = n;
    }

    @Override
    public void setCrossworlds(boolean n) {
        this.crossworlds = n;
    }

    @Override
    public void setMaxDistance(double n) {
        this.distance = n;
    }

    @Override
    public void setMessageCost(double n) {
        this.cost = n;
    }

    @Override
    public void setCostPerMessage(double n) {
        this.cost = n;
    }

    @Override
    public void setShowCostMessage(boolean n) {
        this.show_cost_msg = n;
    }

    @Override
    public void setDelayPerMessage(int n) {
        this.delay = n;
    }
}

