/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.channels;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.BungeecordChannel;
import br.com.devpaulo.legendchat.channels.types.Channel;
import br.com.devpaulo.legendchat.channels.types.PermanentChannel;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ChannelManager {
    private final HashMap<String, Channel> channels = new HashMap();

    public void createChannel(Channel c) {
        if (this.existsChannel(c.getName())) {
            return;
        }
        this.channels.put(c.getName().toLowerCase(), c);
    }

    public void createPermanentChannel(Channel c) {
        if (this.existsChannel(c.getName())) {
            return;
        }
        this.channels.put(c.getName().toLowerCase(), c);
        File channel = new File(Legendchat.getPlugin().getDataFolder(), "channels" + File.separator + c.getName().toLowerCase() + ".yml");
        if (!channel.exists()) {
            try {
                channel.createNewFile();
            }
            catch (Exception e) {
                // empty catch block
            }
            YamlConfiguration channel2 = YamlConfiguration.loadConfiguration((File)channel);
            channel2.set("name", (Object)c.getName());
            channel2.set("nickname", (Object)c.getNickname());
            channel2.set("format", (Object)c.getFormat());
            channel2.set("color", (Object)c.getStringColor());
            channel2.set("shortcutAllowed", (Object)c.isShortcutAllowed());
            channel2.set("needFocus", (Object)c.isFocusNeeded());
            channel2.set("distance", (Object)c.getMaxDistance());
            channel2.set("crossworlds", (Object)c.isCrossworlds());
            channel2.set("delayPerMessage", (Object)c.getDelayPerMessage());
            channel2.set("costPerMessage", (Object)c.getCostPerMessage());
            channel2.set("showCostMessage", (Object)c.showCostMessage());
            try {
                channel2.save(channel);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public void deleteChannel(Channel c) {
        if (!this.existsChannel(c.getName())) {
            return;
        }
        for (Player p : c.getPlayersFocusedInChannel()) {
            Legendchat.getPlayerManager().setPlayerFocusedChannel(p, Legendchat.getDefaultChannel(), false);
        }
        this.channels.remove(c.getName().toLowerCase());
        new File(Legendchat.getPlugin().getDataFolder(), "channels" + File.separator + c.getName().toLowerCase() + ".yml").delete();
    }

    public Channel getChannelByName(String name) {
        if (this.existsChannel(name = name.toLowerCase())) {
            return this.channels.get(name);
        }
        return null;
    }

    public Channel getChannelByNickname(String nickname) {
        for (Channel c : this.getChannels()) {
            if (!c.getNickname().equalsIgnoreCase(nickname)) continue;
            return c;
        }
        return null;
    }

    public Channel getChannelByNameOrNickname(String name_or_nickname) {
        Channel c = this.getChannelByName(name_or_nickname);
        if (c == null) {
            c = this.getChannelByNickname(name_or_nickname);
        }
        return c;
    }

    public boolean existsChannel(String name) {
        return this.channels.containsKey(name.toLowerCase());
    }

    public boolean existsChannelAdvanced(String name_or_nickname) {
        boolean e = this.channels.containsKey(name_or_nickname.toLowerCase());
        if (!e) {
            e = this.getChannelByNickname(name_or_nickname) != null;
        }
        return e;
    }

    public List<Channel> getChannels() {
        ArrayList<Channel> c = new ArrayList<Channel>();
        c.addAll(this.channels.values());
        return c;
    }

    public void loadChannels() {
        String bungee = Legendchat.getPlugin().getConfig().getString("bungeecord.channel");
        this.channels.clear();
        for (File channel : new File(Legendchat.getPlugin().getDataFolder(), "channels").listFiles()) {
            if (!channel.getName().toLowerCase().endsWith(".yml")) continue;
            if (!channel.getName().toLowerCase().equals(channel.getName())) {
                channel.renameTo(new File(Legendchat.getPlugin().getDataFolder(), "channels" + File.separator + channel.getName().toLowerCase()));
            }
            this.loadChannel(channel, bungee);
        }
        for (Player p : Bukkit.getOnlinePlayers()) {
            Legendchat.getPlayerManager().setPlayerFocusedChannel(p, Legendchat.getDefaultChannel(), false);
        }
    }

    private void loadChannel(File channel, String bungee) {
        YamlConfiguration channel2 = YamlConfiguration.loadConfiguration((File)channel);
        if (channel2.getString("name").toLowerCase().equals(bungee.toLowerCase())) {
            this.createPermanentChannel(new BungeecordChannel(channel2.getString("name"), channel2.getString("nickname"), channel2.getString("format"), channel2.getString("color"), channel2.getBoolean("shortcutAllowed"), channel2.getBoolean("needFocus"), channel2.getDouble("distance"), channel2.getBoolean("crossworlds"), channel2.getInt("delayPerMessage"), channel2.getDouble("costPerMessage"), channel2.getBoolean("showCostMessage")));
        } else {
            this.createPermanentChannel(new PermanentChannel(channel2.getString("name"), channel2.getString("nickname"), channel2.getString("format"), channel2.getString("color"), channel2.getBoolean("shortcutAllowed"), channel2.getBoolean("needFocus"), channel2.getDouble("distance"), channel2.getBoolean("crossworlds"), channel2.getInt("delayPerMessage"), channel2.getDouble("costPerMessage"), channel2.getBoolean("showCostMessage")));
        }
    }
}

