/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.censor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CensorManager {
    private final HashMap<String, String> words = new HashMap();

    public void loadCensoredWords(List<String> l) {
        this.words.clear();
        for (String word : l) {
            if (word.contains(";")) {
                this.words.put(word.split(";")[0].toLowerCase(), word.split(";")[1]);
                continue;
            }
            this.words.put(word.split(";")[0].toLowerCase(), "");
        }
    }

    public void addCensoredWord(String word, String replace) {
        if (replace == null) {
            replace = "";
        }
        if (!this.words.containsKey(word.toLowerCase())) {
            this.words.put(word.toLowerCase(), replace);
        }
    }

    public void removeCensoredWord(String word) {
        if (this.words.containsKey(word.toLowerCase())) {
            this.words.remove(word.toLowerCase());
        }
    }

    public boolean hasCensoredWord(String word) {
        return this.words.containsKey(word.toLowerCase());
    }

    public List<String> getAllCensoredWords() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.words.keySet());
        return l;
    }

    public String getReplacementFor(String word) {
        if (this.words.containsKey(word.toLowerCase())) {
            String a = this.words.get(word.toLowerCase());
            if (a.length() == 0) {
                for (int i = 0; i < word.length(); ++i) {
                    a = a + "*";
                }
            }
            return a;
        }
        return null;
    }

    public String censorFunction(String text) {
        String ftext = text.toLowerCase();
        for (String word : this.getAllCensoredWords()) {
            if (!ftext.contains(word)) continue;
            text = text.replaceAll("(?i)" + word, this.getReplacementFor(word));
        }
        return text;
    }
}

