/*
 * Decompiled with CFR 0.152.
 */
package br.com.devpaulo.legendchat.api.events;

import br.com.devpaulo.legendchat.api.Legendchat;
import br.com.devpaulo.legendchat.channels.types.Channel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class BungeecordChatMessageEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private String message = "";
    private String format = "";
    private Channel ch = null;
    private String base_format = "";
    private final Set<Player> recipients = new HashSet<Player>();
    private boolean cancelled = false;
    private final HashMap<String, String> tags = new HashMap();

    public BungeecordChatMessageEvent(Channel ch, String message, String format, String base_format, Set<Player> recipients, HashMap<String, String> tags, boolean cancelled) {
        this.message = message;
        this.recipients.addAll(recipients);
        this.tags.putAll(tags);
        this.cancelled = cancelled;
        this.ch = ch;
        this.base_format = base_format;
        this.format = ChatColor.translateAlternateColorCodes((char)'&', (String)format);
        for (int i = 0; i < format.length(); ++i) {
            String tag;
            if (format.charAt(i) != '{' || (tag = format.substring(i + 1).split("}")[0].toLowerCase()).equals("msg") || this.tags.containsKey(tag)) continue;
            this.tags.put(tag, "");
        }
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message == null ? "" : message;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        if (format != null) {
            this.format = format;
        }
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }

    public Set<Player> getRecipients() {
        return this.recipients;
    }

    public Channel getChannel() {
        return this.ch;
    }

    public String getBaseFormat() {
        return this.base_format;
    }

    public String baseFormatToFormat(String base_format) {
        return Legendchat.format(base_format);
    }

    public List<String> getTags() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.tags.keySet());
        return l;
    }

    public boolean setTagValue(String tag, String value) {
        if (tag == null) {
            return false;
        }
        if (!this.tags.containsKey(tag = tag.toLowerCase())) {
            return false;
        }
        this.tags.remove(tag);
        this.tags.put(tag, value == null ? "" : value);
        return true;
    }

    public String getTagValue(String tag) {
        if (tag == null) {
            return null;
        }
        if (!this.tags.containsKey(tag = tag.toLowerCase())) {
            return null;
        }
        return this.tags.get(tag);
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }
}

