/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot;

import com.google.common.collect.BiMap;
import com.mojang.authlib.GameProfile;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.v1_11_R1.Block;
import net.minecraft.server.v1_11_R1.ChatComponentText;
import net.minecraft.server.v1_11_R1.EnumDifficulty;
import net.minecraft.server.v1_11_R1.EnumGamemode;
import net.minecraft.server.v1_11_R1.EnumProtocol;
import net.minecraft.server.v1_11_R1.EnumProtocolDirection;
import net.minecraft.server.v1_11_R1.IChatBaseComponent;
import net.minecraft.server.v1_11_R1.Packet;
import net.minecraft.server.v1_11_R1.PacketDataSerializer;
import net.minecraft.server.v1_11_R1.PacketHandshakingInSetProtocol;
import net.minecraft.server.v1_11_R1.PacketLoginInEncryptionBegin;
import net.minecraft.server.v1_11_R1.PacketLoginInStart;
import net.minecraft.server.v1_11_R1.PacketLoginOutDisconnect;
import net.minecraft.server.v1_11_R1.PacketLoginOutEncryptionBegin;
import net.minecraft.server.v1_11_R1.PacketLoginOutSetCompression;
import net.minecraft.server.v1_11_R1.PacketLoginOutSuccess;
import net.minecraft.server.v1_11_R1.PacketPlayInAbilities;
import net.minecraft.server.v1_11_R1.PacketPlayInArmAnimation;
import net.minecraft.server.v1_11_R1.PacketPlayInBlockDig;
import net.minecraft.server.v1_11_R1.PacketPlayInBlockPlace;
import net.minecraft.server.v1_11_R1.PacketPlayInBoatMove;
import net.minecraft.server.v1_11_R1.PacketPlayInChat;
import net.minecraft.server.v1_11_R1.PacketPlayInClientCommand;
import net.minecraft.server.v1_11_R1.PacketPlayInCloseWindow;
import net.minecraft.server.v1_11_R1.PacketPlayInCustomPayload;
import net.minecraft.server.v1_11_R1.PacketPlayInEnchantItem;
import net.minecraft.server.v1_11_R1.PacketPlayInEntityAction;
import net.minecraft.server.v1_11_R1.PacketPlayInFlying;
import net.minecraft.server.v1_11_R1.PacketPlayInHeldItemSlot;
import net.minecraft.server.v1_11_R1.PacketPlayInKeepAlive;
import net.minecraft.server.v1_11_R1.PacketPlayInResourcePackStatus;
import net.minecraft.server.v1_11_R1.PacketPlayInSetCreativeSlot;
import net.minecraft.server.v1_11_R1.PacketPlayInSettings;
import net.minecraft.server.v1_11_R1.PacketPlayInSpectate;
import net.minecraft.server.v1_11_R1.PacketPlayInSteerVehicle;
import net.minecraft.server.v1_11_R1.PacketPlayInTabComplete;
import net.minecraft.server.v1_11_R1.PacketPlayInTeleportAccept;
import net.minecraft.server.v1_11_R1.PacketPlayInTransaction;
import net.minecraft.server.v1_11_R1.PacketPlayInUpdateSign;
import net.minecraft.server.v1_11_R1.PacketPlayInUseEntity;
import net.minecraft.server.v1_11_R1.PacketPlayInUseItem;
import net.minecraft.server.v1_11_R1.PacketPlayInVehicleMove;
import net.minecraft.server.v1_11_R1.PacketPlayInWindowClick;
import net.minecraft.server.v1_11_R1.PacketPlayOutAbilities;
import net.minecraft.server.v1_11_R1.PacketPlayOutAnimation;
import net.minecraft.server.v1_11_R1.PacketPlayOutAttachEntity;
import net.minecraft.server.v1_11_R1.PacketPlayOutBed;
import net.minecraft.server.v1_11_R1.PacketPlayOutBlockAction;
import net.minecraft.server.v1_11_R1.PacketPlayOutBlockBreakAnimation;
import net.minecraft.server.v1_11_R1.PacketPlayOutBlockChange;
import net.minecraft.server.v1_11_R1.PacketPlayOutBoss;
import net.minecraft.server.v1_11_R1.PacketPlayOutCamera;
import net.minecraft.server.v1_11_R1.PacketPlayOutChat;
import net.minecraft.server.v1_11_R1.PacketPlayOutCloseWindow;
import net.minecraft.server.v1_11_R1.PacketPlayOutCollect;
import net.minecraft.server.v1_11_R1.PacketPlayOutCombatEvent;
import net.minecraft.server.v1_11_R1.PacketPlayOutCustomPayload;
import net.minecraft.server.v1_11_R1.PacketPlayOutCustomSoundEffect;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntity;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityEffect;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityEquipment;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityHeadRotation;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityStatus;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityTeleport;
import net.minecraft.server.v1_11_R1.PacketPlayOutEntityVelocity;
import net.minecraft.server.v1_11_R1.PacketPlayOutExperience;
import net.minecraft.server.v1_11_R1.PacketPlayOutExplosion;
import net.minecraft.server.v1_11_R1.PacketPlayOutGameStateChange;
import net.minecraft.server.v1_11_R1.PacketPlayOutHeldItemSlot;
import net.minecraft.server.v1_11_R1.PacketPlayOutKeepAlive;
import net.minecraft.server.v1_11_R1.PacketPlayOutKickDisconnect;
import net.minecraft.server.v1_11_R1.PacketPlayOutLogin;
import net.minecraft.server.v1_11_R1.PacketPlayOutMap;
import net.minecraft.server.v1_11_R1.PacketPlayOutMapChunk;
import net.minecraft.server.v1_11_R1.PacketPlayOutMount;
import net.minecraft.server.v1_11_R1.PacketPlayOutMultiBlockChange;
import net.minecraft.server.v1_11_R1.PacketPlayOutNamedEntitySpawn;
import net.minecraft.server.v1_11_R1.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.v1_11_R1.PacketPlayOutOpenSignEditor;
import net.minecraft.server.v1_11_R1.PacketPlayOutOpenWindow;
import net.minecraft.server.v1_11_R1.PacketPlayOutPlayerInfo;
import net.minecraft.server.v1_11_R1.PacketPlayOutPlayerListHeaderFooter;
import net.minecraft.server.v1_11_R1.PacketPlayOutPosition;
import net.minecraft.server.v1_11_R1.PacketPlayOutRemoveEntityEffect;
import net.minecraft.server.v1_11_R1.PacketPlayOutResourcePackSend;
import net.minecraft.server.v1_11_R1.PacketPlayOutRespawn;
import net.minecraft.server.v1_11_R1.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.server.v1_11_R1.PacketPlayOutScoreboardObjective;
import net.minecraft.server.v1_11_R1.PacketPlayOutScoreboardScore;
import net.minecraft.server.v1_11_R1.PacketPlayOutScoreboardTeam;
import net.minecraft.server.v1_11_R1.PacketPlayOutServerDifficulty;
import net.minecraft.server.v1_11_R1.PacketPlayOutSetCooldown;
import net.minecraft.server.v1_11_R1.PacketPlayOutSetSlot;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnEntity;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnEntityExperienceOrb;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnEntityPainting;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnEntityWeather;
import net.minecraft.server.v1_11_R1.PacketPlayOutSpawnPosition;
import net.minecraft.server.v1_11_R1.PacketPlayOutStatistic;
import net.minecraft.server.v1_11_R1.PacketPlayOutTabComplete;
import net.minecraft.server.v1_11_R1.PacketPlayOutTileEntityData;
import net.minecraft.server.v1_11_R1.PacketPlayOutTitle;
import net.minecraft.server.v1_11_R1.PacketPlayOutTransaction;
import net.minecraft.server.v1_11_R1.PacketPlayOutUnloadChunk;
import net.minecraft.server.v1_11_R1.PacketPlayOutUpdateAttributes;
import net.minecraft.server.v1_11_R1.PacketPlayOutUpdateHealth;
import net.minecraft.server.v1_11_R1.PacketPlayOutUpdateTime;
import net.minecraft.server.v1_11_R1.PacketPlayOutVehicleMove;
import net.minecraft.server.v1_11_R1.PacketPlayOutWindowData;
import net.minecraft.server.v1_11_R1.PacketPlayOutWindowItems;
import net.minecraft.server.v1_11_R1.PacketPlayOutWorldBorder;
import net.minecraft.server.v1_11_R1.PacketPlayOutWorldEvent;
import net.minecraft.server.v1_11_R1.PacketPlayOutWorldParticles;
import net.minecraft.server.v1_11_R1.PacketStatusInPing;
import net.minecraft.server.v1_11_R1.PacketStatusInStart;
import net.minecraft.server.v1_11_R1.PacketStatusOutPong;
import net.minecraft.server.v1_11_R1.PacketStatusOutServerInfo;
import net.minecraft.server.v1_11_R1.ServerPing;
import net.minecraft.server.v1_11_R1.SoundCategory;
import net.minecraft.server.v1_11_R1.SoundEffectType;
import net.minecraft.server.v1_11_R1.WorldType;
import org.bukkit.Material;
import org.spigotmc.SpigotConfig;
import protocolsupport.api.chat.ChatAPI;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.chat.components.TextComponent;
import protocolsupport.api.events.ServerPingResponseEvent;
import protocolsupport.protocol.utils.types.Position;
import protocolsupport.utils.ReflectionUtils;
import protocolsupport.zplatform.PlatformPacketFactory;
import protocolsupport.zplatform.impl.spigot.SpigotMiscUtils;

public class SpigotPacketFactory
implements PlatformPacketFactory {
    private static final BaseComponent empty = new TextComponent("");
    private final UUID profileUUID = UUID.randomUUID();
    private static final PacketDataSerializer emptyPDS = new PacketDataSerializer(Unpooled.EMPTY_BUFFER);

    @Override
    public Object createInboundInventoryClosePacket() {
        return new PacketPlayInCloseWindow();
    }

    @Override
    public Object createOutboundChatPacket(String message, int position) {
        return new PacketPlayOutChat(IChatBaseComponent.ChatSerializer.a((String)message), (byte)position);
    }

    @Override
    public Object createTabHeaderFooterPacket(BaseComponent header, BaseComponent footer) {
        PacketDataSerializer serializer = new PacketDataSerializer(Unpooled.buffer());
        serializer.a(ChatAPI.toJSON(header != null ? header : empty));
        serializer.a(ChatAPI.toJSON(footer != null ? footer : empty));
        PacketPlayOutPlayerListHeaderFooter packet = new PacketPlayOutPlayerListHeaderFooter();
        try {
            packet.a(serializer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return packet;
    }

    @Override
    public Object createTitleResetPacket() {
        return new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.CLEAR, null);
    }

    @Override
    public Object createTitleClearPacket() {
        return new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.RESET, null);
    }

    @Override
    public Object createTitleMainPacket(String title) {
        return new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.TITLE, IChatBaseComponent.ChatSerializer.a((String)title));
    }

    @Override
    public Object createTitleSubPacket(String title) {
        return new PacketPlayOutTitle(PacketPlayOutTitle.EnumTitleAction.SUBTITLE, IChatBaseComponent.ChatSerializer.a((String)title));
    }

    @Override
    public Object createTitleParamsPacket(int fadeIn, int stay, int fadeOut) {
        return new PacketPlayOutTitle(fadeIn, stay, fadeOut);
    }

    @Override
    public Object createLoginDisconnectPacket(String message) {
        return new PacketLoginOutDisconnect((IChatBaseComponent)new ChatComponentText(message));
    }

    @Override
    public Object createPlayDisconnectPacket(String message) {
        return new PacketPlayOutKickDisconnect((IChatBaseComponent)new ChatComponentText(message));
    }

    @Override
    public Object createLoginEncryptionBeginPacket(PublicKey publicKey, byte[] randomBytes) {
        return new PacketLoginOutEncryptionBegin("", publicKey, randomBytes);
    }

    @Override
    public Object createSetCompressionPacket(int threshold) {
        return new PacketLoginOutSetCompression(threshold);
    }

    @Override
    public Object createBlockBreakSoundPacket(Position pos, Material type) {
        SoundEffectType blocksound = Block.getById((int)type.getId()).getStepSound();
        return new PacketPlayOutNamedSoundEffect(blocksound.e(), SoundCategory.BLOCKS, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (blocksound.a() + 1.0f) / 2.0f, blocksound.b() * 0.8f);
    }

    @Override
    public Object createStatusPongPacket(long pingId) {
        return new PacketStatusOutPong(pingId);
    }

    @Override
    public Object createStausServerInfoPacket(List<String> profiles, ServerPingResponseEvent.ProtocolInfo info, String icon, String motd, int maxPlayers) {
        ServerPing.ServerPingPlayerSample playerSample = new ServerPing.ServerPingPlayerSample(maxPlayers, profiles.size());
        Collections.shuffle(profiles);
        GameProfile[] gprofiles = new GameProfile[profiles.size()];
        for (int i = 0; i < profiles.size(); ++i) {
            gprofiles[i] = new GameProfile(this.profileUUID, profiles.get(i));
        }
        gprofiles = Arrays.copyOfRange(gprofiles, 0, Math.min(gprofiles.length, SpigotConfig.playerSample));
        playerSample.a(gprofiles);
        ServerPing serverping = new ServerPing();
        serverping.setFavicon(icon);
        serverping.setMOTD((IChatBaseComponent)new ChatComponentText(motd));
        serverping.setPlayerSample(playerSample);
        serverping.setServerInfo(new ServerPing.ServerData(info.getName(), info.getId()));
        return new PacketStatusOutServerInfo(serverping);
    }

    @Override
    public Object createLoginSuccessPacket(protocolsupport.protocol.utils.authlib.GameProfile profile) {
        return new PacketLoginOutSuccess(SpigotMiscUtils.toMojangGameProfile(profile));
    }

    @Override
    public Object createEmptyCustomPayloadPacket(String tag) {
        return new PacketPlayOutCustomPayload(tag, emptyPDS);
    }

    @Override
    public Object createFakeJoinGamePacket() {
        return new PacketPlayOutLogin(0, EnumGamemode.NOT_SET, false, 0, EnumDifficulty.EASY, 60, WorldType.NORMAL, false);
    }

    @Override
    public int getOutLoginDisconnectPacketId() {
        return SpigotPacketFactory.getOutId(PacketLoginOutDisconnect.class);
    }

    @Override
    public int getOutLoginEncryptionBeginPacketId() {
        return SpigotPacketFactory.getOutId(PacketLoginOutEncryptionBegin.class);
    }

    @Override
    public int getOutLoginSuccessPacketId() {
        return SpigotPacketFactory.getOutId(PacketLoginOutSuccess.class);
    }

    @Override
    public int getOutLoginSetCompressionPacketId() {
        return SpigotPacketFactory.getOutId(PacketLoginOutSetCompression.class);
    }

    @Override
    public int getOutStatusServerInfoPacketId() {
        return SpigotPacketFactory.getOutId(PacketStatusOutServerInfo.class);
    }

    @Override
    public int getOutStatusPongPacketId() {
        return SpigotPacketFactory.getOutId(PacketStatusOutPong.class);
    }

    @Override
    public int getOutPlayKeepAlivePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutKeepAlive.class);
    }

    @Override
    public int getOutPlayLoginPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutLogin.class);
    }

    @Override
    public int getOutPlayChatPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutChat.class);
    }

    @Override
    public int getOutPlayUpdateTimePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutUpdateTime.class);
    }

    @Override
    public int getOutPlayEntityEquipmentPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityEquipment.class);
    }

    @Override
    public int getOutPlaySpawnPositionPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnPosition.class);
    }

    @Override
    public int getOutPlayUpdateHealthPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutUpdateHealth.class);
    }

    @Override
    public int getOutPlayRespawnPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutRespawn.class);
    }

    @Override
    public int getOutPlayPositionPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutPosition.class);
    }

    @Override
    public int getOutPlayHeldSlotPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutHeldItemSlot.class);
    }

    @Override
    public int getOutPlayBedPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutBed.class);
    }

    @Override
    public int getOutPlayAnimationPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutAnimation.class);
    }

    @Override
    public int getOutPlaySpawnNamedPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutNamedEntitySpawn.class);
    }

    @Override
    public int getOutPlayCollectEffectPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCollect.class);
    }

    @Override
    public int getOutPlaySpawnObjectPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnEntity.class);
    }

    @Override
    public int getOutPlaySpawnLivingPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnEntityLiving.class);
    }

    @Override
    public int getOutPlaySpawnPaintingPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnEntityPainting.class);
    }

    @Override
    public int getOutPlaySpawnExpOrbPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnEntityExperienceOrb.class);
    }

    @Override
    public int getOutPlayEntityVelocityPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityVelocity.class);
    }

    @Override
    public int getOutPlayEntityDestroyPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityDestroy.class);
    }

    @Override
    public int getOutPlayEntityPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntity.class);
    }

    @Override
    public int getOutPlayEntityRelMovePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntity.PacketPlayOutRelEntityMove.class);
    }

    @Override
    public int getOutPlayEntityLookPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntity.PacketPlayOutEntityLook.class);
    }

    @Override
    public int getOutPlayEntityRelMoveLookPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntity.PacketPlayOutRelEntityMoveLook.class);
    }

    @Override
    public int getOutPlayEntityTeleportPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityTeleport.class);
    }

    @Override
    public int getOutPlayEntityHeadRotationPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityHeadRotation.class);
    }

    @Override
    public int getOutPlayEntityStatusPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityStatus.class);
    }

    @Override
    public int getOutPlayEntityLeashPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutAttachEntity.class);
    }

    @Override
    public int getOutPlayEntityMetadataPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityMetadata.class);
    }

    @Override
    public int getOutPlayEntityEffectAddPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutEntityEffect.class);
    }

    @Override
    public int getOutPlayEntityEffectRemovePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutRemoveEntityEffect.class);
    }

    @Override
    public int getOutPlayExperiencePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutExperience.class);
    }

    @Override
    public int getOutPlayEntityAttributesPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutUpdateAttributes.class);
    }

    @Override
    public int getOutPlayChunkSinglePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutMapChunk.class);
    }

    @Override
    public int getOutPlayBlockChangeMultiPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutMultiBlockChange.class);
    }

    @Override
    public int getOutPlayBlockChangeSinglePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutBlockChange.class);
    }

    @Override
    public int getOutPlayBlockActionPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutBlockAction.class);
    }

    @Override
    public int getOutPlayBlockBreakAnimationPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutBlockBreakAnimation.class);
    }

    @Override
    public int getOutPlayExplosionPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutExplosion.class);
    }

    @Override
    public int getOutPlayWorldEventPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutWorldEvent.class);
    }

    @Override
    public int getOutPlayWorldSoundPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutNamedSoundEffect.class);
    }

    @Override
    public int getOutPlayWorldParticlesPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutWorldParticles.class);
    }

    @Override
    public int getOutPlayGameStateChangePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutGameStateChange.class);
    }

    @Override
    public int getOutPlaySpawnWeatherPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSpawnEntityWeather.class);
    }

    @Override
    public int getOutPlayWindowOpenPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutOpenWindow.class);
    }

    @Override
    public int getOutPlayWindowClosePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCloseWindow.class);
    }

    @Override
    public int getOutPlayWindowSetSlotPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSetSlot.class);
    }

    @Override
    public int getOutPlayWindowSetItemsPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutWindowItems.class);
    }

    @Override
    public int getOutPlayWindowDataPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutWindowData.class);
    }

    @Override
    public int getOutPlayWindowTransactionPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutTransaction.class);
    }

    @Override
    public int getOutPlayMapPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutMap.class);
    }

    @Override
    public int getOutPlayUpdateTilePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutTileEntityData.class);
    }

    @Override
    public int getOutPlaySignEditorPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutOpenSignEditor.class);
    }

    @Override
    public int getOutPlayStatisticsPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutStatistic.class);
    }

    @Override
    public int getOutPlayPlayerInfoPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutPlayerInfo.class);
    }

    @Override
    public int getOutPlayAbilitiesPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutAbilities.class);
    }

    @Override
    public int getOutPlayTabCompletePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutTabComplete.class);
    }

    @Override
    public int getOutPlayScoreboardObjectivePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutScoreboardObjective.class);
    }

    @Override
    public int getOutPlayScoreboardScorePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutScoreboardScore.class);
    }

    @Override
    public int getOutPlayScoreboardDisplaySlotPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutScoreboardDisplayObjective.class);
    }

    @Override
    public int getOutPlayScoreboardTeamPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutScoreboardTeam.class);
    }

    @Override
    public int getOutPlayCustomPayloadPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCustomPayload.class);
    }

    @Override
    public int getOutPlayKickDisconnectPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutKickDisconnect.class);
    }

    @Override
    public int getOutPlayResourcePackPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutResourcePackSend.class);
    }

    @Override
    public int getOutPlayCameraPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCamera.class);
    }

    @Override
    public int getOutPlayWorldBorderPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutWorldBorder.class);
    }

    @Override
    public int getOutPlayTitlePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutTitle.class);
    }

    @Override
    public int getOutPlayPlayerListHeaderFooterPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutPlayerListHeaderFooter.class);
    }

    @Override
    public int getOutPlaySetPassengersPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutMount.class);
    }

    @Override
    public int getOutPlayChunkUnloadPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutUnloadChunk.class);
    }

    @Override
    public int getOutPlayWorldCustomSoundPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCustomSoundEffect.class);
    }

    @Override
    public int getOutPlayServerDifficultyPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutServerDifficulty.class);
    }

    @Override
    public int getOutPlayCombatEventPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutCombatEvent.class);
    }

    @Override
    public int getOutPlayBossBarPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutBoss.class);
    }

    @Override
    public int getOutPlaySetCooldownPacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutSetCooldown.class);
    }

    @Override
    public int getOutPlayVehicleMovePacketId() {
        return SpigotPacketFactory.getOutId(PacketPlayOutVehicleMove.class);
    }

    @Override
    public int getInHandshakeStartPacketId() {
        return SpigotPacketFactory.getInId(PacketHandshakingInSetProtocol.class);
    }

    @Override
    public int getInStatusRequestPacketId() {
        return SpigotPacketFactory.getInId(PacketStatusInStart.class);
    }

    @Override
    public int getInStatusPingPacketId() {
        return SpigotPacketFactory.getInId(PacketStatusInPing.class);
    }

    @Override
    public int getInLoginStartPacketId() {
        return SpigotPacketFactory.getInId(PacketLoginInStart.class);
    }

    @Override
    public int getInLoginEncryptionBeginPacketId() {
        return SpigotPacketFactory.getInId(PacketLoginInEncryptionBegin.class);
    }

    @Override
    public int getInPlayKeepAlivePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInKeepAlive.class);
    }

    @Override
    public int getInPlayChatPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInChat.class);
    }

    @Override
    public int getInPlayUseEntityPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInUseEntity.class);
    }

    @Override
    public int getInPlayPlayerPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInFlying.class);
    }

    @Override
    public int getInPlayPositionPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInFlying.PacketPlayInPosition.class);
    }

    @Override
    public int getInPlayLookPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInFlying.PacketPlayInLook.class);
    }

    @Override
    public int getInPlayPositionLookPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInFlying.PacketPlayInPositionLook.class);
    }

    @Override
    public int getInPlayBlockDigPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInBlockDig.class);
    }

    @Override
    public int getInPlayBlockPlacePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInBlockPlace.class);
    }

    @Override
    public int getInPlayHeldSlotPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInHeldItemSlot.class);
    }

    @Override
    public int getInPlayAnimationPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInArmAnimation.class);
    }

    @Override
    public int getInPlayEntityActionPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInEntityAction.class);
    }

    @Override
    public int getInPlayMoveVehiclePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInVehicleMove.class);
    }

    @Override
    public int getInPlaySteerBoatPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInBoatMove.class);
    }

    @Override
    public int getInPlaySteerVehiclePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInSteerVehicle.class);
    }

    @Override
    public int getInPlayWindowClosePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInCloseWindow.class);
    }

    @Override
    public int getInPlayWindowClickPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInWindowClick.class);
    }

    @Override
    public int getInPlayWindowTransactionPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInTransaction.class);
    }

    @Override
    public int getInPlayCreativeSetSlotPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInSetCreativeSlot.class);
    }

    @Override
    public int getInPlayEnchantSelectPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInEnchantItem.class);
    }

    @Override
    public int getInPlayUpdateSignPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInUpdateSign.class);
    }

    @Override
    public int getInPlayAbilitiesPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInAbilities.class);
    }

    @Override
    public int getInPlayTabCompletePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInTabComplete.class);
    }

    @Override
    public int getInPlaySettingsPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInSettings.class);
    }

    @Override
    public int getInPlayClientCommandPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInClientCommand.class);
    }

    @Override
    public int getInPlayCustomPayloadPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInCustomPayload.class);
    }

    @Override
    public int getInPlayUseItemPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInUseItem.class);
    }

    @Override
    public int getInPlaySpectatePacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInSpectate.class);
    }

    @Override
    public int getInPlayResourcePackStatusPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInResourcePackStatus.class);
    }

    @Override
    public int getInPlayTeleportAcceptPacketId() {
        return SpigotPacketFactory.getInId(PacketPlayInTeleportAccept.class);
    }

    private static Map<EnumProtocolDirection, BiMap<Integer, Class<? extends Packet<?>>>> getPacketIdMap(Class<?> packetClass) {
        Map protocolMap = null;
        try {
            protocolMap = (Map)ReflectionUtils.setAccessible(EnumProtocol.class.getDeclaredField("f")).get(null);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to get packet id map", t);
        }
        EnumProtocol protocol = (EnumProtocol)protocolMap.get(packetClass);
        try {
            return (Map)ReflectionUtils.setAccessible(EnumProtocol.class.getDeclaredField("h")).get(protocol);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to get packet id map", t);
        }
    }

    private static final int getOutId(Class<?> packetClass) {
        return (Integer)SpigotPacketFactory.getPacketIdMap(packetClass).get(EnumProtocolDirection.CLIENTBOUND).inverse().get(packetClass);
    }

    private static final int getInId(Class<?> packetClass) {
        return (Integer)SpigotPacketFactory.getPacketIdMap(packetClass).get(EnumProtocolDirection.SERVERBOUND).inverse().get(packetClass);
    }
}

