/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.network;

import com.flowpowered.network.Message;
import com.flowpowered.network.protocol.AbstractProtocol;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.glowstone.entity.meta.profile.PlayerProfile;
import net.glowstone.entity.meta.profile.PlayerProperty;
import net.glowstone.net.GlowSession;
import net.glowstone.net.ProxyData;
import net.glowstone.net.pipeline.MessageHandler;
import net.glowstone.net.protocol.ProtocolType;
import org.bukkit.entity.Player;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.zplatform.impl.glowstone.GlowStoneMiscUtils;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public class GlowStoneNetworkManagerWrapper
extends NetworkManagerWrapper {
    private static final AttributeKey<Object> packet_listener_key = AttributeKey.valueOf((String)"ps_packet_listener");
    private static final UUID fakeUUID = UUID.randomUUID();
    private final MessageHandler handler;

    public static Object getPacketListener(GlowSession session) {
        return session.getChannel().attr(packet_listener_key).get();
    }

    public static GlowStoneNetworkManagerWrapper getFromChannel(Channel channel) {
        return new GlowStoneNetworkManagerWrapper((MessageHandler)channel.pipeline().get("handler"));
    }

    public GlowStoneNetworkManagerWrapper(MessageHandler handler) {
        this.handler = handler;
    }

    public GlowSession getSession() {
        return (GlowSession)this.handler.getSession().get();
    }

    @Override
    public Object unwrap() {
        return this.handler;
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getSession().getAddress();
    }

    @Override
    public void setAddress(InetSocketAddress address) {
        ProxyData old = this.getSession().getProxyData();
        if (old != null) {
            this.getSession().setProxyData(new ProxyData(null, null, address, null, old.getProfile().getUniqueId(), old.getProfile().getProperties()));
        } else {
            this.getSession().setProxyData(new ProxyData(null, null, address, null, fakeUUID, Collections.emptyList()));
        }
    }

    @Override
    public boolean isConnected() {
        return this.getChannel().isOpen();
    }

    @Override
    public Channel getChannel() {
        return this.getSession().getChannel();
    }

    @Override
    public void close(String closeMessage) {
        this.getSession().disconnect(closeMessage);
    }

    @Override
    public void sendPacket(Object packet) {
        this.getSession().send((Message)packet);
    }

    @Override
    public void sendPacket(Object packet, GenericFutureListener<? extends Future<? super Void>> genericListener, GenericFutureListener<? extends Future<? super Void>> ... futureListeners) {
        this.getSession().sendWithFuture((Message)packet).addListener(genericListener).addListeners(futureListeners);
    }

    public NetworkState getProtocol() {
        AbstractProtocol proto = this.getSession().getProtocol();
        for (ProtocolType type : ProtocolType.values()) {
            if (type.getProtocol() != proto) continue;
            return GlowStoneMiscUtils.protocolToNetState(type);
        }
        throw new IllegalStateException(MessageFormat.format("Unkown protocol {0}", proto));
    }

    @Override
    public void setProtocol(NetworkState state) {
        this.getSession().setProtocol(GlowStoneMiscUtils.netStateToProtocol(state));
    }

    @Override
    public Object getPacketListener() {
        return GlowStoneNetworkManagerWrapper.getPacketListener(this.getSession());
    }

    @Override
    public void setPacketListener(Object listener) {
        this.getChannel().attr(packet_listener_key).set(listener);
    }

    @Override
    public UUID getSpoofedUUID() {
        PlayerProfile profile = this.getSpoofedProfile();
        return profile != null ? profile.getUniqueId() : null;
    }

    @Override
    public PlayerPropertiesResolveEvent.ProfileProperty[] getSpoofedProperties() {
        PlayerProfile profile = this.getSpoofedProfile();
        return profile == null ? null : profile.getProperties().stream().map(property -> new PlayerPropertiesResolveEvent.ProfileProperty(property.getName(), property.getValue(), property.getSignature())).collect(Collectors.toList()).toArray(new PlayerPropertiesResolveEvent.ProfileProperty[0]);
    }

    private PlayerProfile getSpoofedProfile() {
        ProxyData proxydata = this.getSession().getProxyData();
        return proxydata != null ? proxydata.getProfile("?[]___PSFakeProfile!!!!!!!") : null;
    }

    @Override
    public void setSpoofedProfile(UUID uuid, PlayerPropertiesResolveEvent.ProfileProperty[] properties) {
        ProxyData old = this.getSession().getProxyData();
        List glowproperties = Collections.emptyList();
        if (properties != null) {
            glowproperties = Arrays.stream(properties).map(prop -> new PlayerProperty(prop.getName(), prop.getValue(), prop.getSignature())).collect(Collectors.toList());
        }
        if (old != null) {
            this.getSession().setProxyData(new ProxyData(null, null, old.getAddress(), null, uuid, glowproperties));
        } else {
            this.getSession().setProxyData(new ProxyData(null, null, this.getAddress(), null, uuid, glowproperties));
        }
    }

    @Override
    public Player getBukkitPlayer() {
        return this.getSession().getPlayer();
    }
}

