/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.registry;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.NoSuchElementException;
import protocolsupport.zplatform.network.NetworkState;

public class PacketIdTransformerRegistry {
    private final EnumMap<NetworkState, int[]> registry = new EnumMap(NetworkState.class);

    public PacketIdTransformerRegistry() {
        for (NetworkState state : NetworkState.values()) {
            int[] newIds = new int[256];
            Arrays.fill(newIds, -1);
            this.registry.put(state, newIds);
        }
    }

    public void register(NetworkState protocol, int packetId, int newPacketId) {
        this.registry.get((Object)((Object)protocol))[packetId] = newPacketId;
    }

    public int getNewPacketId(NetworkState protocol, int packetId) {
        int[] newIds = this.registry.get((Object)protocol);
        if (newIds == null) {
            return -1;
        }
        int id = newIds[packetId];
        if (id == -1) {
            throw new NoSuchElementException("No packet id found for state " + (Object)((Object)protocol) + " and packet id " + packetId);
        }
        return id;
    }
}

