/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.utils.registry;

import java.util.NoSuchElementException;
import protocolsupport.zplatform.network.NetworkState;

public class MiddleTransformerRegistry<T> {
    private static final int listenerStateLength = NetworkState.values().length;
    private final LazyNewInstance<T>[] registry = new LazyNewInstance[listenerStateLength * 256];
    private InitCallBack<T> callback;

    public void register(NetworkState state, int packetId, Class<? extends T> packetTransformer) {
        this.registry[MiddleTransformerRegistry.toKey((NetworkState)state, (int)packetId)] = new LazyNewInstance<T>(packetTransformer);
    }

    public void setCallBack(InitCallBack<T> callback) {
        this.callback = callback;
    }

    public T getTransformer(NetworkState state, int packetId) throws InstantiationException, IllegalAccessException {
        LazyNewInstance<T> transformer = this.registry[MiddleTransformerRegistry.toKey(state, packetId)];
        if (transformer == null) {
            throw new NoSuchElementException("No transformer found for state " + (Object)((Object)state) + " and packet id " + packetId);
        }
        T object = transformer.getInstance();
        if (this.callback != null) {
            this.callback.onInit(object);
        }
        return object;
    }

    static int toKey(NetworkState protocol, int packetId) {
        return protocol.ordinal() << 8 | packetId;
    }

    @FunctionalInterface
    public static interface InitCallBack<T> {
        public void onInit(T var1);
    }

    private static class LazyNewInstance<T> {
        private final Class<? extends T> clazz;
        private T instance;

        public LazyNewInstance(Class<? extends T> clazz) {
            this.clazz = clazz;
        }

        public T getInstance() throws InstantiationException, IllegalAccessException {
            if (this.instance == null) {
                this.instance = this.clazz.newInstance();
            }
            return this.instance;
        }
    }
}

