/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.pipeline.common;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import protocolsupport.protocol.pipeline.IPacketSplitter;

public class VarIntFrameDecoder
implements IPacketSplitter {
    private int packetLength = -1;

    @Override
    public void split(ChannelHandlerContext ctx, ByteBuf input, List<Object> list) {
        if (this.packetLength == -1) {
            input.markReaderIndex();
            int tmpPacketLength = 0;
            for (int i = 0; i < 3; ++i) {
                if (!input.isReadable()) {
                    input.resetReaderIndex();
                    return;
                }
                byte part = input.readByte();
                tmpPacketLength |= (part & 0x7F) << i * 7;
                if (part < 0) continue;
                this.packetLength = tmpPacketLength;
                return;
            }
            throw new CorruptedFrameException("Packet length varint length is more than 21 bits");
        }
        if (input.readableBytes() < this.packetLength) {
            return;
        }
        list.add(input.readBytes(this.packetLength));
        this.packetLength = -1;
    }
}

