/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.packet.middleimpl.serverbound.play.v_1_4__1_5;

import protocolsupport.protocol.packet.ServerBoundPacket;
import protocolsupport.protocol.packet.middle.ServerBoundMiddlePacket;
import protocolsupport.protocol.packet.middle.serverbound.play.MiddleTeleportAccept;
import protocolsupport.protocol.packet.middleimpl.ServerBoundPacketData;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.recyclable.RecyclableCollection;
import protocolsupport.utils.recyclable.RecyclableEmptyList;
import protocolsupport.utils.recyclable.RecyclableSingletonList;

public class PositionLook
extends ServerBoundMiddlePacket {
    protected double x;
    protected double y;
    protected double yhead;
    protected double z;
    protected float yaw;
    protected float pitch;
    protected boolean onGround;

    @Override
    public void readFromClientData(ProtocolSupportPacketDataSerializer serializer) {
        this.x = serializer.readDouble();
        this.y = serializer.readDouble();
        this.yhead = serializer.readDouble();
        this.z = serializer.readDouble();
        this.yaw = serializer.readFloat();
        this.pitch = serializer.readFloat();
        this.onGround = serializer.readBoolean();
    }

    @Override
    public RecyclableCollection<ServerBoundPacketData> toNative() {
        if (this.y == -999.0 && this.yhead == -999.0) {
            ServerBoundPacketData creator = ServerBoundPacketData.create(ServerBoundPacket.PLAY_LOOK);
            creator.writeFloat(this.yaw);
            creator.writeFloat(this.pitch);
            creator.writeBoolean(this.onGround);
            return RecyclableSingletonList.create(creator);
        }
        if (!this.cache.isTeleportConfirmNeeded()) {
            ServerBoundPacketData creator = ServerBoundPacketData.create(ServerBoundPacket.PLAY_POSITION_LOOK);
            creator.writeDouble(this.x);
            creator.writeDouble(this.y);
            creator.writeDouble(this.z);
            creator.writeFloat(this.yaw);
            creator.writeFloat(this.pitch);
            creator.writeBoolean(this.onGround);
            return RecyclableSingletonList.create(creator);
        }
        int teleportId = this.cache.tryTeleportConfirm(this.x, this.y, this.z);
        if (teleportId == -1) {
            return RecyclableEmptyList.get();
        }
        return MiddleTeleportAccept.create(teleportId);
    }
}

