/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.protocol.legacyremapper.chunk;

import protocolsupport.utils.Utils;

public class BlockStorageWriter {
    private final long[] blockdata;
    private final int bitsPerBlock;
    private final long singleValMask;

    public BlockStorageWriter(int bitsPerBlock, int blocks) {
        this.bitsPerBlock = bitsPerBlock;
        this.singleValMask = (1L << bitsPerBlock) - 1L;
        this.blockdata = new long[Utils.ceilToBase(blocks * bitsPerBlock, 64) / 64];
    }

    public void setBlockState(int index, int blockstate) {
        int bitStartIndex = index * this.bitsPerBlock;
        int arrStartIndex = bitStartIndex >> 6;
        int arrEndIndex = bitStartIndex + this.bitsPerBlock - 1 >> 6;
        int localStartBitIndex = bitStartIndex & 0x3F;
        this.blockdata[arrStartIndex] = this.blockdata[arrStartIndex] & (this.singleValMask << localStartBitIndex ^ 0xFFFFFFFFFFFFFFFFL) | ((long)blockstate & this.singleValMask) << localStartBitIndex;
        if (arrStartIndex != arrEndIndex) {
            int thisPartSift = 64 - localStartBitIndex;
            int otherPartShift = this.bitsPerBlock - thisPartSift;
            this.blockdata[arrEndIndex] = this.blockdata[arrEndIndex] >>> otherPartShift << otherPartShift | ((long)blockstate & this.singleValMask) >> thisPartSift;
        }
    }

    public long[] getBlockData() {
        return this.blockdata;
    }
}

