/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.utils;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import javax.imageio.ImageIO;
import org.bukkit.util.CachedServerIcon;
import protocolsupport.libs.org.apache.commons.lang3.Validate;
import protocolsupport.zplatform.ServerPlatform;

public class IconUtils {
    public static String loadIcon(File file) throws IOException {
        return IconUtils.loadIcon(new FileInputStream(file));
    }

    public static String loadIcon(InputStream rawStream) throws IOException {
        return IconUtils.loadIcon(ImageIO.read(rawStream));
    }

    public static String loadIcon(BufferedImage image) throws IOException {
        Validate.isTrue(image.getWidth() == 64, "Must be 64 pixels wide", new Object[0]);
        Validate.isTrue(image.getHeight() == 64, "Must be 64 pixels high", new Object[0]);
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "PNG", data);
        return "data:image/png;base64," + Base64.getEncoder().encodeToString(data.toByteArray());
    }

    public static String fromBukkit(CachedServerIcon icon) {
        return ServerPlatform.get().getMiscUtils().convertBukkitIconToBase64(icon);
    }
}

