/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api.chat.components;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import protocolsupport.api.chat.components.BaseComponent;
import protocolsupport.api.chat.components.TextComponent;
import protocolsupport.protocol.legacyremapper.LegacyChat;
import protocolsupport.protocol.utils.i18n.I18NData;

public class TranslateComponent
extends BaseComponent {
    private final String translationKey;
    private final List<BaseComponent> args = new ArrayList<BaseComponent>();

    @Deprecated
    public TranslateComponent(String translationKey, Object ... values) {
        this.translationKey = translationKey;
        this.args.addAll(Lists.transform(Arrays.asList(values), (Function)new Function<Object, BaseComponent>(){

            public BaseComponent apply(Object v) {
                return v instanceof BaseComponent ? (BaseComponent)v : new TextComponent(v.toString());
            }
        }));
    }

    public TranslateComponent(String translationKey, BaseComponent ... values) {
        this.translationKey = translationKey;
        this.args.addAll(Arrays.asList(values));
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    @Deprecated
    public List<Object> getArgs() {
        return Lists.transform(this.args, (Function)new Function<BaseComponent, Object>(){

            public Object apply(BaseComponent v) {
                return v;
            }
        });
    }

    public List<BaseComponent> getTranslationArgs() {
        return this.args;
    }

    @Override
    public String getValue() {
        return this.getValue("en_us");
    }

    public String getValue(String lang) {
        return I18NData.i18n(lang, this.translationKey, Lists.transform(this.args, (Function)new Function<BaseComponent, String>(){

            public String apply(BaseComponent v) {
                return LegacyChat.toText(v);
            }
        }).toArray());
    }
}

