/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.api;

import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.bukkit.entity.Player;
import protocolsupport.api.ProtocolVersion;

public abstract class Connection {
    protected volatile ProtocolVersion version = ProtocolVersion.UNKNOWN;
    protected final CopyOnWriteArrayList<PacketSendListener> sendListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<PacketReceiveListener> receiveListeners = new CopyOnWriteArrayList();
    private final ConcurrentHashMap<String, Object> metadata = new ConcurrentHashMap();

    public abstract Object getNetworkManager();

    public abstract boolean isConnected();

    public abstract InetSocketAddress getRawAddress();

    public abstract InetSocketAddress getAddress();

    public abstract void changeAddress(InetSocketAddress var1);

    public abstract Player getPlayer();

    public ProtocolVersion getVersion() {
        return this.version;
    }

    public abstract void receivePacket(Object var1);

    public abstract void sendPacket(Object var1);

    public void addPacketSendListener(PacketSendListener listener) {
        this.sendListeners.add(listener);
    }

    public void removePacketSendListener(PacketSendListener listener) {
        this.sendListeners.remove(listener);
    }

    public void addPacketReceiveListener(PacketReceiveListener listener) {
        this.receiveListeners.add(listener);
    }

    public void removePacketReceiveListener(PacketReceiveListener listener) {
        this.receiveListeners.remove(listener);
    }

    public void addMetadata(String key, Object obj) {
        this.metadata.put(key, obj);
    }

    public Object getMetadata(String key) {
        return this.metadata.get(key);
    }

    public Object removeMetadata(String key) {
        return this.metadata.remove(key);
    }

    public boolean hasMetadata(String key) {
        return this.metadata.containsKey(key);
    }

    @FunctionalInterface
    public static interface PacketReceiveListener {
        public boolean onPacketReceiving(Object var1);
    }

    @FunctionalInterface
    public static interface PacketSendListener {
        public boolean onPacketSending(Object var1);
    }
}

