/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomConfig {
    private JavaPlugin plugin;
    private String resourceLocation;
    private String destination;
    private FileConfiguration customConfig = null;
    private File customConfigFile = null;

    public CustomConfig(JavaPlugin plugin, String resourceLocation, String destination) {
        this.plugin = plugin;
        this.resourceLocation = resourceLocation;
        this.destination = destination;
        Map oldConfig = this.get().getValues(true);
        this.saveDefault();
        for (Map.Entry entry : this.customConfig.getDefaults().getValues(true).entrySet()) {
            if (oldConfig.containsKey(entry.getKey())) {
                this.customConfig.set((String)entry.getKey(), oldConfig.get(entry.getKey()));
                continue;
            }
            this.customConfig.set((String)entry.getKey(), entry.getValue());
        }
        this.save();
    }

    public void reload() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.plugin.getDataFolder(), this.destination);
        }
        this.customConfig = YamlConfiguration.loadConfiguration((File)this.customConfigFile);
        InputStreamReader defConfigStream = null;
        try {
            InputStream resource = this.plugin.getResource(this.resourceLocation);
            if (resource == null) {
                this.plugin.getLogger().severe("Le fichier " + this.resourceLocation + " est manquant!");
                return;
            }
            defConfigStream = new InputStreamReader(resource, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.plugin.getLogger().severe("Erreur pendant la lecture du fichier " + this.resourceLocation + "!");
        }
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            this.customConfig.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration get() {
        if (this.customConfig == null) {
            this.reload();
        }
        return this.customConfig;
    }

    public void save() {
        if (this.customConfig == null || this.customConfigFile == null) {
            return;
        }
        try {
            this.get().save(this.customConfigFile);
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.SEVERE, "Sauvegarde de la configuration " + this.customConfigFile + " impossible!", ex);
        }
    }

    public void saveDefault() {
        if (this.customConfigFile == null) {
            this.customConfigFile = new File(this.plugin.getDataFolder(), this.destination);
        }
        if (!this.customConfigFile.exists()) {
            this.plugin.saveResource(this.resourceLocation, false);
        }
    }
}

