/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.LowOwnedLand;
import com.jcdesimp.landlord.persistantData.User;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHome
implements LandlordCommand {
    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Seul les joueurs peuvent faire cette commande!");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1 && player.hasPermission("landlord.player.sethome")) {
            Location loc = player.getLocation();
            LowOwnedLand land = LowOwnedLand.getApplicableLand(loc);
            if (land != null && (land.getOwnerName().equalsIgnoreCase(player.getName()) || land.isFriend(player))) {
                this.setHome(player.getName(), loc);
                player.sendMessage(ChatColor.GREEN + "Votre home a bien \u00e9t\u00e9 modifi\u00e9");
            } else {
                player.sendMessage(ChatColor.RED + "Vous pouvez poser votre home seulement dans un terrain au moins friend");
            }
        } else if (args.length == 2 && player.hasPermission("landlord.admin.sethome")) {
            this.setHome(args[1], player.getLocation());
            player.sendMessage(ChatColor.GREEN + "Le home de " + args[1] + " a bien \u00e9t\u00e9 modifi\u00e9");
        } else {
            player.sendMessage(ChatColor.RED + "Votre commande n'est pas valide");
        }
        return true;
    }

    public void setHome(String player, Location loc) {
        User user = (User)Landlord.getInstance().getDatabase().find(User.class).where().eq("userName", (Object)player).findUnique();
        if (user == null) {
            user = new User();
            user.setUserName(player);
        }
        user.setHomeLocation(loc);
        Landlord.getInstance().getDatabase().save((Object)user);
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.player.sethome")) {
            return null;
        }
        String usage = "/#{label} #{cmd}";
        String desc = "Place le home \u00e0 la position.";
        return Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"sethome"};
    }
}

