/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord.commands;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.Utils;
import com.jcdesimp.landlord.persistantData.OwnedLand;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ClearWorld
implements LandlordCommand {
    private Landlord plugin;

    public ClearWorld(Landlord plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args, String label) {
        if (!sender.hasPermission("landlord.admin.clearworld")) {
            sender.sendMessage(ChatColor.RED + "Vous n'avez pas la permission.");
            return true;
        }
        if (args.length > 1) {
            List land;
            if (args.length > 2) {
                String playerName = args[2];
                land = this.plugin.getDatabase().find(OwnedLand.class).where().eq("ownerName", (Object)playerName).eq("worldName", (Object)args[1]).findList();
            } else {
                if (sender instanceof Player) {
                    sender.sendMessage(ChatColor.RED + "Vous ne pouvez supprimer des mondes entiers que depuis la console.");
                    return true;
                }
                land = this.plugin.getDatabase().find(OwnedLand.class).where().eq("worldName", (Object)args[1]).findList();
            }
            if (land.isEmpty()) {
                sender.sendMessage(ChatColor.RED + "Il n'y a pas de terrain \u00e0 supprimer.");
                return true;
            }
            for (OwnedLand l : land) {
                l.getLowLand().delete();
            }
            sender.sendMessage(ChatColor.GREEN + "Les terrains ont \u00e9t\u00e9 supprim\u00e9s!");
        } else {
            sender.sendMessage(ChatColor.RED + "format: " + label + " clearworld <world> [<player>]");
        }
        return true;
    }

    @Override
    public String getHelpText(CommandSender sender) {
        if (!sender.hasPermission("landlord.admin.clearworld")) {
            return null;
        }
        String usage = "/#{label} #{cmd} <world> [player]";
        String desc = "Supprime tous les terrains poss\u00e9d\u00e9s par un joueur dans un monde. Supprime tous les terrains d'un monde (depuis la console seulement).";
        String chunkWarning = "Ne r\u00e9g\u00e9n\u00e8re pas les chunks.";
        String helpString = "";
        helpString = String.valueOf(helpString) + Utils.helpString(usage, desc, this.getTriggers()[0].toLowerCase());
        if (this.plugin.getConfig().getBoolean("options.regenOnUnclaim", false)) {
            helpString = String.valueOf(helpString) + ChatColor.YELLOW + " " + ChatColor.ITALIC + chunkWarning;
        }
        return helpString;
    }

    @Override
    public String[] getTriggers() {
        return new String[]{"clearworld"};
    }
}

