/*
 * Decompiled with CFR 0.152.
 */
package com.jcdesimp.landlord;

import com.jcdesimp.landlord.Landlord;
import com.jcdesimp.landlord.commands.AddFriend;
import com.jcdesimp.landlord.commands.Claim;
import com.jcdesimp.landlord.commands.ClearWorld;
import com.jcdesimp.landlord.commands.FriendAll;
import com.jcdesimp.landlord.commands.Friends;
import com.jcdesimp.landlord.commands.Help;
import com.jcdesimp.landlord.commands.Home;
import com.jcdesimp.landlord.commands.Info;
import com.jcdesimp.landlord.commands.Lag;
import com.jcdesimp.landlord.commands.LandList;
import com.jcdesimp.landlord.commands.LandlordCommand;
import com.jcdesimp.landlord.commands.ListPlayer;
import com.jcdesimp.landlord.commands.Manage;
import com.jcdesimp.landlord.commands.Reload;
import com.jcdesimp.landlord.commands.SetHome;
import com.jcdesimp.landlord.commands.ShowMap;
import com.jcdesimp.landlord.commands.Unclaim;
import com.jcdesimp.landlord.commands.Unfriend;
import com.jcdesimp.landlord.commands.UnfriendAll;
import java.util.HashMap;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class LandlordCommandExecutor
implements CommandExecutor {
    private HashMap<String, LandlordCommand> registeredCommands = new HashMap();
    private Help helpCommand;

    public LandlordCommandExecutor(Landlord plugin) {
        this.helpCommand = new Help(plugin, this);
        this.register(this.helpCommand);
        this.register(new Claim(plugin));
        this.register(new Unclaim(plugin));
        this.register(new Home());
        this.register(new SetHome());
        this.register(new AddFriend(plugin));
        this.register(new Unfriend(plugin));
        this.register(new Friends(plugin));
        this.register(new FriendAll(plugin));
        this.register(new UnfriendAll(plugin));
        this.register(new ShowMap(plugin));
        this.register(new Manage(plugin));
        this.register(new LandList(plugin));
        this.register(new Info(plugin));
        this.register(new ListPlayer(plugin));
        this.register(new ClearWorld(plugin));
        this.register(new Reload(plugin));
        this.register(new Lag());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("landlord")) {
            if (args.length == 0 || !this.registeredCommands.containsKey(args[0].toLowerCase())) {
                return this.helpCommand.execute(sender, new String[0], label);
            }
            return this.registeredCommands.get(args[0].toLowerCase()).execute(sender, args, label);
        }
        return false;
    }

    public boolean register(LandlordCommand cmd) {
        String[] commandTriggers = cmd.getTriggers();
        if (commandTriggers.length <= 0) {
            return false;
        }
        String[] stringArray = commandTriggers;
        int n = commandTriggers.length;
        int n2 = 0;
        while (n2 < n) {
            String trigger = stringArray[n2];
            if (this.registeredCommands.containsKey(trigger.toLowerCase())) {
                System.out.println("Failed to register command with alias '" + trigger + "', already taken!");
            } else {
                this.registeredCommands.put(trigger.toLowerCase(), cmd);
            }
            ++n2;
        }
        this.helpCommand.addCommand(cmd);
        return true;
    }
}

