/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.listeners;

import com.lenis0012.bukkit.marriage2.MData;
import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.config.Settings;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.misc.Reflection;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.packets.Packet;
import com.lenis0012.bukkit.marriage2.libs.pluginutils.modules.packets.PacketModule;
import com.lenis0012.bukkit.marriage2.misc.Cooldown;
import java.lang.reflect.Method;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;

public class KissListener
implements Listener {
    private final Method GET_PARTICLE_BY_ID = Reflection.getNMSMethod("EnumParticle", "a", Integer.TYPE);
    private final Cooldown<String> cooldown;
    private final MarriageCore core;
    private final Random random = new Random();

    public KissListener(MarriageCore core) {
        this.core = core;
        this.cooldown = new Cooldown(Settings.COOLDOWN_KISS.value().intValue(), TimeUnit.SECONDS);
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEntityEvent event) {
        if (!Settings.KISSES_ENABLED.value().booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        Entity e = event.getRightClicked();
        if (!(e instanceof Player)) {
            return;
        }
        Player clicked = (Player)e;
        if (!player.isSneaking() || !clicked.isSneaking()) {
            return;
        }
        MPlayer mp = this.core.getMPlayer(player.getUniqueId());
        if (!mp.isMarried()) {
            return;
        }
        MData data = mp.getMarriage();
        if (!clicked.getUniqueId().toString().equalsIgnoreCase(data.getOtherPlayer(player.getUniqueId()).toString())) {
            return;
        }
        if (!this.cooldown.performCheck(player.getName()) || !this.cooldown.performCheck(clicked.getName())) {
            return;
        }
        Location l1 = player.getEyeLocation();
        Location l2 = clicked.getEyeLocation();
        this.sendPacket(l1, l2);
    }

    private void sendPacket(Location eye1, Location eye2) {
        Location l = eye1.clone().add((eye2.getX() - eye1.getX()) / 2.0, (eye2.getY() - eye1.getY()) / 2.0, (eye2.getZ() - eye1.getZ()) / 2.0);
        int min = Settings.KISSES_AMOUNT_MIN.value();
        int max = Settings.KISSES_AMOUNT_MAX.value();
        int amount = min + this.random.nextInt(max - min + 1);
        PacketModule module = this.core.getPlugin().getModule(PacketModule.class);
        Packet packet = module.createPacket("PacketPlayOutWorldParticles");
        packet.write("a", Reflection.invokeMethod(this.GET_PARTICLE_BY_ID, null, 34));
        packet.write("b", Float.valueOf((float)l.getX()));
        packet.write("c", Float.valueOf((float)l.getY()));
        packet.write("d", Float.valueOf((float)l.getZ()));
        packet.write("e", Float.valueOf(0.3f));
        packet.write("f", Float.valueOf(0.3f));
        packet.write("g", Float.valueOf(0.3f));
        packet.write("h", Float.valueOf(1.0f));
        packet.write("i", amount);
        module.broadcastPacket(l.getWorld(), packet);
    }
}

