/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.libs.updater.bukkit;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lenis0012.bukkit.marriage2.libs.updater.api.BaseUpdater;
import com.lenis0012.bukkit.marriage2.libs.updater.api.ReleaseType;
import com.lenis0012.bukkit.marriage2.libs.updater.api.Version;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class BukkitUpdater
extends BaseUpdater {
    private static final String BASE_URL = "https://api.curseforge.com";
    private static final String API_FILES = "/servermods/files?projectIds=";
    private static final String API_SEARCH = "/servermods/projects?search=";
    private int projectId = -1;

    public BukkitUpdater(Plugin plugin, File pluginFile, final String projectId, boolean enabled) {
        super(plugin, pluginFile);
        this.enabled = enabled;
        if (projectId.startsWith("slug:")) {
            Bukkit.getScheduler().runTaskAsynchronously(plugin, new Runnable(){

                @Override
                public void run() {
                    BukkitUpdater.this.readSlug(projectId.substring("slug:".length()));
                }
            });
        } else {
            this.projectId = Integer.parseInt(projectId);
        }
        this.loadGravityFile(false);
    }

    @Override
    protected void read() {
        if (this.projectId < 0) {
            return;
        }
        JsonElement json = this.readJsonFromURL("https://api.curseforge.com/servermods/files?projectIds=" + this.projectId, true);
        if (json == null) {
            return;
        }
        JsonArray files = json.getAsJsonArray();
        JsonObject latest = null;
        ReleaseType type = null;
        for (int i = files.size() - 1; i >= 0; --i) {
            JsonObject file = files.get(i).getAsJsonObject();
            type = ReleaseType.valueOf(file.get("releaseType").getAsString().toUpperCase());
            if (type.ordinal() < this.channel.ordinal()) continue;
            latest = file;
            break;
        }
        if (latest == null) {
            return;
        }
        String name = latest.get("name").getAsString();
        String serverVersion = latest.get("gameVersion").getAsString();
        String downloadURL = latest.get("downloadUrl").getAsString();
        this.newVersion = new Version(name, type, serverVersion, downloadURL);
        this.isOutdated = !this.compareVersions(this.currentVersion, name);
    }

    @Override
    public String downloadVersion() {
        String result = super.downloadVersion();
        if (result == null) {
            this.readChangelog(new File(Bukkit.getUpdateFolderFile(), this.pluginFile.getName()));
        }
        return result;
    }

    @Override
    public boolean isBukkitUpdater() {
        return true;
    }

    private void readSlug(String slug) {
        JsonArray projects = this.readJsonFromURL("https://api.curseforge.com/servermods/projects?search=" + slug, true).getAsJsonArray();
        if (projects.size() < 1) {
            return;
        }
        JsonObject project = projects.get(0).getAsJsonObject();
        this.projectId = project.get("id").getAsInt();
    }

    private void readChangelog(File file) {
        ItemStack book = new ItemStack(Material.WRITTEN_BOOK, 1);
        BookMeta meta = (BookMeta)book.getItemMeta();
        meta.setAuthor("lenis0012");
        meta.setTitle(this.currentVersion + " Changelog");
        JsonObject json = this.readJsonFromJar(file, "changelog.json");
        if (json == null || !json.get("version").getAsString().equalsIgnoreCase(this.newVersion.getName())) {
            return;
        }
        JsonArray pages = json.get("data").getAsJsonArray();
        for (int i = 0; i < pages.size(); ++i) {
            JsonArray lines = pages.get(i).getAsJsonArray();
            StringBuilder page = new StringBuilder();
            for (int j = 0; j < lines.size(); ++j) {
                page.append(lines.get(j).getAsString()).append('\n');
            }
            page.setLength(page.length() - 1);
            meta.addPage(new String[]{page.toString()});
        }
        book.setItemMeta((ItemMeta)meta);
        this.changelog = book;
    }
}

