/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.internal;

import com.google.common.collect.Maps;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.internal.MarriageBase;
import com.lenis0012.bukkit.marriage2.internal.MarriageCore;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MarriageCommandExecutor
implements CommandExecutor {
    private final MarriageCore core;
    private final Map<String, Command> commands = Maps.newHashMap();

    public MarriageCommandExecutor(MarriageBase core) {
        this.core = (MarriageCore)core;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String label, String[] args) {
        String subCommand = args.length > 0 ? args[0] : "help";
        Command command = this.commands.get(subCommand.toLowerCase());
        if (command == null) {
            command = this.commands.get("marry");
        }
        if (args.length > command.getMinArgs()) {
            if (command.getPermission() == null || command.getPermission().has(sender)) {
                if (command.isAllowConsole() || sender instanceof Player) {
                    command.prepare(sender, args);
                    command.execute();
                } else {
                    sender.sendMessage(ChatColor.RED + "You must be a player to execute this command.");
                }
            } else {
                sender.sendMessage(ChatColor.RED + "You are not permitted to use this command.");
            }
        } else {
            sender.sendMessage(ChatColor.RED + "You have not specified enough arguments for this command.");
        }
        return true;
    }

    public void regster(Class<? extends Command> commandClass) {
        try {
            Command command = commandClass.getConstructor(Marriage.class).newInstance(this.core);
            for (String alias : command.getAliases()) {
                this.commands.put(alias.toLowerCase(), command);
            }
        }
        catch (Exception e) {
            this.core.getLogger().log(Level.SEVERE, "Failed to register sub command", e);
        }
    }

    public Collection<Command> getSubCommands() {
        return this.commands.values();
    }
}

