/*
 * Decompiled with CFR 0.152.
 */
package com.lenis0012.bukkit.marriage2.commands;

import com.lenis0012.bukkit.marriage2.MPlayer;
import com.lenis0012.bukkit.marriage2.Marriage;
import com.lenis0012.bukkit.marriage2.commands.Command;
import com.lenis0012.bukkit.marriage2.config.Message;
import com.lenis0012.bukkit.marriage2.config.Settings;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;

public class CommandMarry
extends Command {
    public CommandMarry(Marriage marriage) {
        super(marriage, "marry", new String[0]);
        if (Settings.ENABLE_PRIEST.value().booleanValue()) {
            this.setDescription("Marry 2 players with eachother.");
            this.setUsage("<player1> <player2>");
            this.setMinArgs(1);
        } else {
            this.setDescription("Request a marriage with another player.");
            this.setExecutionFee(Settings.PRICE_MARRY);
            this.setUsage("<player>");
            this.setMinArgs(0);
        }
        this.setAllowConsole(false);
    }

    @Override
    public void execute() {
        if (Settings.ENABLE_PRIEST.value().booleanValue()) {
            Player player1 = this.getArgAsPlayer(-1);
            Player player2 = this.getArgAsPlayer(0);
            if (player1 == null) {
                this.reply(Message.PLAYER_NOT_FOUND, this.getArg(-1));
                return;
            }
            if (player2 == null) {
                this.reply(Message.PLAYER_NOT_FOUND, this.getArg(0));
                return;
            }
            MPlayer mp1 = this.marriage.getMPlayer(player1.getUniqueId());
            MPlayer mp2 = this.marriage.getMPlayer(player2.getUniqueId());
            if (mp1.isMarried() || mp2.isMarried()) {
                this.reply(Message.ALREADY_MARRIED, new Object[0]);
                return;
            }
            MPlayer mp = this.marriage.getMPlayer(this.player.getUniqueId());
            if (!mp.isPriest()) {
                this.reply(Message.NOT_A_PRIEST, new Object[0]);
                return;
            }
            this.marriage.marry(mp1, mp2);
            this.broadcast(Message.MARRIED, player1.getName(), player2.getName());
        } else {
            Player target = this.getArgAsPlayer(-1);
            if (target == null) {
                this.reply(Message.PLAYER_NOT_FOUND, this.getArg(-1));
                return;
            }
            if (target.getName().equalsIgnoreCase(this.player.getName())) {
                this.reply(Message.MARRY_SELF, new Object[0]);
                return;
            }
            MPlayer mPlayer = this.marriage.getMPlayer(this.player.getUniqueId());
            if (mPlayer.isMarried()) {
                this.reply(Message.ALREADY_MARRIED, new Object[0]);
                return;
            }
            MPlayer mTarget = this.marriage.getMPlayer(target.getUniqueId());
            if (mTarget.isMarried()) {
                this.reply(Message.TARGET_ALREADY_MARRIED, this.getArg(-1));
                return;
            }
            if (mPlayer.isMarriageRequested(target.getUniqueId())) {
                EconomyResponse response;
                if (this.getExecutionFee() > 0.0 && !(response = this.marriage.dependencies().getEconomyService().withdrawPlayer((OfflinePlayer)target, this.getExecutionFee())).transactionSuccess()) {
                    this.reply(Message.PARTNER_FEE, new Object[0]);
                    target.sendMessage(response.errorMessage);
                    return;
                }
                this.marriage.marry(mTarget, mPlayer);
                this.player.setMetadata("marriedTo", (MetadataValue)new FixedMetadataValue(this.marriage.getPlugin(), (Object)target.getName()));
                target.setMetadata("marriedTo", (MetadataValue)new FixedMetadataValue(this.marriage.getPlugin(), (Object)this.player.getName()));
                this.broadcast(Message.MARRIED, this.player.getName(), target.getName());
            } else if (!mTarget.isMarriageRequested(this.player.getUniqueId())) {
                if (!this.hasFee()) {
                    this.reply(Message.INSUFFICIENT_MONEY, this.marriage.dependencies().getEconomyService().format(this.getExecutionFee()));
                    return;
                }
                mTarget.requestMarriage(this.player.getUniqueId());
                target.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)String.format(Message.MARRIAGE_REQUESTED.toString(), this.player.getName(), this.player.getName())));
                this.reply(Message.REQUEST_SENT, target.getName());
            } else {
                this.reply(Message.COOLDOWN, new Object[0]);
            }
        }
    }
}

