/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import java.text.MessageFormat;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.minecraft.server.v1_11_R1.PacketDecompressor;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;

public class SpigotPacketDecompressor
extends PacketDecompressor {
    private static final int maxPacketLength = (int)Math.pow(2.0, 21.0);
    private final Inflater inflater = new Inflater();

    public SpigotPacketDecompressor(int threshold) {
        super(threshold);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.inflater.end();
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf from, List<Object> list) throws DataFormatException {
        if (!from.isReadable()) {
            return;
        }
        int uncompressedlength = ProtocolSupportPacketDataSerializer.readVarInt(from);
        if (uncompressedlength == 0) {
            list.add(from.readBytes(from.readableBytes()));
        } else {
            if (uncompressedlength > maxPacketLength) {
                throw new DecoderException(MessageFormat.format("Badly compressed packet - size of {0} is larger than protocol maximum of {1}", uncompressedlength, maxPacketLength));
            }
            this.inflater.setInput(ProtocolSupportPacketDataSerializer.toArray(from));
            byte[] uncompressed = new byte[uncompressedlength];
            this.inflater.inflate(uncompressed);
            list.add(Unpooled.wrappedBuffer((byte[])uncompressed));
            this.inflater.reset();
        }
    }
}

