/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.network.pipeline;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.DecoderException;
import java.io.IOException;
import java.util.List;
import net.minecraft.server.v1_11_R1.EnumProtocol;
import net.minecraft.server.v1_11_R1.EnumProtocolDirection;
import net.minecraft.server.v1_11_R1.NetworkManager;
import net.minecraft.server.v1_11_R1.Packet;
import net.minecraft.server.v1_11_R1.PacketDataSerializer;
import protocolsupport.protocol.serializer.ProtocolSupportPacketDataSerializer;
import protocolsupport.utils.netty.WrappingBuffer;

public class SpigotPacketDecoder
extends ByteToMessageDecoder {
    private final WrappingBuffer wrapper = new WrappingBuffer();
    private final PacketDataSerializer nativeSerializer = new PacketDataSerializer((ByteBuf)this.wrapper);

    protected void decode(ChannelHandlerContext ctx, ByteBuf input, List<Object> list) throws IllegalAccessException, InstantiationException {
        if (!input.isReadable()) {
            return;
        }
        EnumProtocol protocol = (EnumProtocol)ctx.channel().attr(NetworkManager.c).get();
        this.wrapper.setBuf(input);
        int packetId = ProtocolSupportPacketDataSerializer.readVarInt(this.wrapper);
        Packet packet = protocol.a(EnumProtocolDirection.SERVERBOUND, packetId);
        if (packet == null) {
            throw new DecoderException("Bad packet id " + packetId);
        }
        try {
            packet.a(this.nativeSerializer);
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
        if (this.nativeSerializer.isReadable()) {
            throw new DecoderException("Did not read all data from packet " + packet.getClass().getName() + ", bytes left: " + this.nativeSerializer.readableBytes());
        }
        list.add(packet);
    }
}

