/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.spigot.network;

import com.mojang.authlib.properties.Property;
import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.v1_11_R1.ChatComponentText;
import net.minecraft.server.v1_11_R1.EnumProtocol;
import net.minecraft.server.v1_11_R1.IChatBaseComponent;
import net.minecraft.server.v1_11_R1.NetworkManager;
import net.minecraft.server.v1_11_R1.Packet;
import net.minecraft.server.v1_11_R1.PacketListener;
import net.minecraft.server.v1_11_R1.PlayerConnection;
import org.bukkit.entity.Player;
import protocolsupport.api.events.PlayerPropertiesResolveEvent;
import protocolsupport.zplatform.network.NetworkManagerWrapper;
import protocolsupport.zplatform.network.NetworkState;

public class SpigotNetworkManagerWrapper
extends NetworkManagerWrapper {
    private final NetworkManager internal;

    public static SpigotNetworkManagerWrapper getFromChannel(Channel channel) {
        return new SpigotNetworkManagerWrapper((NetworkManager)channel.pipeline().get("packet_handler"));
    }

    public SpigotNetworkManagerWrapper(NetworkManager internal) {
        this.internal = internal;
    }

    public NetworkManager unwrap() {
        return this.internal;
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.internal.getSocketAddress();
    }

    @Override
    public InetSocketAddress getRawAddress() {
        return (InetSocketAddress)this.internal.getRawAddress();
    }

    @Override
    public void setAddress(InetSocketAddress address) {
        this.internal.l = address;
    }

    @Override
    public boolean isConnected() {
        return this.internal.isConnected();
    }

    @Override
    public Channel getChannel() {
        return this.internal.channel;
    }

    @Override
    public void close(String closeMessage) {
        this.internal.close((IChatBaseComponent)new ChatComponentText(closeMessage));
    }

    @Override
    public void sendPacket(Object packet) {
        this.internal.sendPacket((Packet)packet);
    }

    @Override
    public void sendPacket(Object packet, GenericFutureListener<? extends Future<? super Void>> genericListener, GenericFutureListener<? extends Future<? super Void>> ... futureListeners) {
        this.internal.sendPacket((Packet)packet, genericListener, futureListeners);
    }

    @Override
    public void setProtocol(NetworkState state) {
        this.internal.setProtocol(EnumProtocol.values()[state.ordinal()]);
    }

    public PacketListener getPacketListener() {
        return this.internal.i();
    }

    @Override
    public void setPacketListener(Object listener) {
        this.internal.setPacketListener((PacketListener)listener);
    }

    @Override
    public UUID getSpoofedUUID() {
        return this.internal.spoofedUUID;
    }

    @Override
    public PlayerPropertiesResolveEvent.ProfileProperty[] getSpoofedProperties() {
        if (this.internal.spoofedProfile == null) {
            return null;
        }
        return Arrays.asList(this.internal.spoofedProfile).stream().map(prop -> new PlayerPropertiesResolveEvent.ProfileProperty(prop.getName(), prop.getValue(), prop.getSignature())).collect(Collectors.toList()).toArray(new PlayerPropertiesResolveEvent.ProfileProperty[0]);
    }

    @Override
    public void setSpoofedProfile(UUID uuid, PlayerPropertiesResolveEvent.ProfileProperty[] properties) {
        this.internal.spoofedUUID = uuid;
        if (properties != null) {
            this.internal.spoofedProfile = Arrays.stream(properties).map(prop -> new Property(prop.getName(), prop.getValue(), prop.getSignature())).collect(Collectors.toList()).toArray(new Property[0]);
        }
    }

    @Override
    public Player getBukkitPlayer() {
        PacketListener listener = this.getPacketListener();
        if (listener instanceof PlayerConnection) {
            return ((PlayerConnection)listener).player.getBukkitEntity();
        }
        return null;
    }
}

