/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.network.handler;

import com.flowpowered.network.Message;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.glowstone.EventFactory;
import net.glowstone.GlowServer;
import net.glowstone.entity.GlowPlayer;
import net.glowstone.entity.meta.profile.PlayerProfile;
import net.glowstone.io.PlayerDataService;
import net.glowstone.net.GlowSession;
import net.glowstone.net.message.play.game.UserListItemMessage;
import org.bukkit.BanList;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerLoginEvent;
import protocolsupport.protocol.packet.handler.AbstractLoginListenerPlay;
import protocolsupport.protocol.utils.authlib.GameProfile;
import protocolsupport.utils.ReflectionUtils;
import protocolsupport.zplatform.impl.glowstone.GlowStoneMiscUtils;
import protocolsupport.zplatform.impl.glowstone.network.GlowStoneNetworkManagerWrapper;
import protocolsupport.zplatform.impl.glowstone.network.handler.GlowStoneTickableListener;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public class GlowStoneLoginListenerPlay
extends AbstractLoginListenerPlay
implements GlowStoneTickableListener {
    protected static final GlowServer server = GlowStoneMiscUtils.getServer();
    private static final Field playerField = ReflectionUtils.getField(GlowSession.class, "player");
    private static final Field onlineField = ReflectionUtils.getField(GlowSession.class, "online");

    protected GlowStoneLoginListenerPlay(NetworkManagerWrapper networkmanager, GameProfile profile, boolean onlineMode, String hostname) {
        super(networkmanager, profile, onlineMode, hostname);
    }

    @Override
    protected AbstractLoginListenerPlay.JoinData createJoinData() {
        PlayerProfile glowstoneProfile = GlowStoneMiscUtils.toGlowStoneGameProfile(this.profile);
        final PlayerDataService.PlayerReader reader = server.getPlayerDataService().beginReadingData(glowstoneProfile.getUniqueId());
        GlowPlayer player = new GlowPlayer(((GlowStoneNetworkManagerWrapper)this.networkManager).getSession(), glowstoneProfile, reader);
        return new AbstractLoginListenerPlay.JoinData((Player)player, new Object[]{player, reader}){

            @Override
            protected void close() {
                reader.close();
            }
        };
    }

    @Override
    protected void checkBans(PlayerLoginEvent event, Object[] data) {
        String name = event.getPlayer().getName();
        String hostaddr = event.getAddress().getHostAddress();
        BanList nameBans = server.getBanList(BanList.Type.NAME);
        BanList ipBans = server.getBanList(BanList.Type.IP);
        if (nameBans.isBanned(name)) {
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, "Banned: " + nameBans.getBanEntry(name).getReason());
        } else if (ipBans.isBanned(hostaddr)) {
            event.disallow(PlayerLoginEvent.Result.KICK_BANNED, "Banned: " + ipBans.getBanEntry(hostaddr).getReason());
        } else if (server.hasWhitelist() && !event.getPlayer().isWhitelisted()) {
            event.disallow(PlayerLoginEvent.Result.KICK_WHITELIST, "You are not whitelisted on this server.");
        } else if (server.getOnlinePlayers().size() >= server.getMaxPlayers()) {
            event.disallow(PlayerLoginEvent.Result.KICK_FULL, "The server is full (" + server.getMaxPlayers() + " players).");
        }
    }

    @Override
    protected void joinGame(Object[] data) {
        this.networkManager.setPacketListener(null);
        GlowPlayer glowplayer = (GlowPlayer)data[0];
        PlayerDataService.PlayerReader reader = (PlayerDataService.PlayerReader)data[1];
        GlowSession session = ((GlowStoneNetworkManagerWrapper)this.networkManager).getSession();
        try {
            playerField.set(session, glowplayer);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unable to set GlowSession player field", e);
        }
        glowplayer.join(session, reader);
        glowplayer.getWorld().getRawPlayers().add(glowplayer);
        try {
            onlineField.set(session, true);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IllegalStateException("Unable to set GlowSession online field", e);
        }
        GlowServer.logger.info(glowplayer.getName() + " [" + this.networkManager.getAddress() + "] connected, UUID: " + glowplayer.getUniqueId());
        String message = EventFactory.onPlayerJoin((Player)glowplayer).getJoinMessage();
        if (message != null && !message.isEmpty()) {
            server.broadcastMessage(message);
        }
        UserListItemMessage addMessage = new UserListItemMessage(UserListItemMessage.Action.ADD_PLAYER, glowplayer.getUserListEntry());
        ArrayList<UserListItemMessage.Entry> entries = new ArrayList<UserListItemMessage.Entry>();
        for (GlowPlayer other : server.getRawOnlinePlayers()) {
            if (!other.equals((Object)glowplayer) && other.canSee((Player)glowplayer)) {
                other.getSession().send((Message)addMessage);
            }
            if (!glowplayer.canSee((Player)other)) continue;
            entries.add(other.getUserListEntry());
        }
        session.send((Message)new UserListItemMessage(UserListItemMessage.Action.ADD_PLAYER, entries));
    }
}

