/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.network.handler;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import net.glowstone.net.pipeline.CompressionHandler;
import protocolsupport.protocol.packet.handler.AbstractLoginListener;
import protocolsupport.protocol.packet.handler.AbstractLoginListenerPlay;
import protocolsupport.zplatform.impl.glowstone.network.handler.GlowStoneLoginListenerPlay;
import protocolsupport.zplatform.impl.glowstone.network.handler.GlowStoneTickableListener;
import protocolsupport.zplatform.network.NetworkManagerWrapper;

public abstract class GlowStoneLoginListener
extends AbstractLoginListener
implements GlowStoneTickableListener {
    private final boolean hasCompression;

    public GlowStoneLoginListener(NetworkManagerWrapper networkmanager, String hostname, boolean hasCompression) {
        super(networkmanager, hostname);
        this.hasCompression = hasCompression;
    }

    @Override
    protected boolean hasCompression() {
        return this.hasCompression;
    }

    @Override
    protected void enableCompression(int compressionLevel) {
        Channel channel = this.networkManager.getChannel();
        if (compressionLevel >= 0) {
            channel.pipeline().addAfter("framing", "compression", (ChannelHandler)new CompressionHandler(compressionLevel));
        }
    }

    @Override
    protected AbstractLoginListenerPlay getLoginListenerPlay() {
        return new GlowStoneLoginListenerPlay(this.networkManager, this.profile, this.isOnlineMode, this.hostname);
    }
}

