/*
 * Decompiled with CFR 0.152.
 */
package protocolsupport.zplatform.impl.glowstone.injector;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import protocolsupport.protocol.pipeline.common.LogicHandler;
import protocolsupport.protocol.pipeline.initial.InitialPacketDecoder;
import protocolsupport.protocol.pipeline.timeout.SimpleReadTimeoutHandler;
import protocolsupport.protocol.storage.ProtocolStorage;
import protocolsupport.zplatform.ServerPlatform;
import protocolsupport.zplatform.impl.glowstone.GlowStoneConnectionImpl;
import protocolsupport.zplatform.impl.glowstone.network.pipeline.GlowStoneFramingHandler;
import protocolsupport.zplatform.impl.glowstone.network.pipeline.GlowStoneSyncConnectionTicker;

public class GlowStoneServerConnectionChannel
extends ChannelInitializer<Channel> {
    protected void initChannel(Channel channel) throws Exception {
        try {
            channel.config().setOption(ChannelOption.IP_TOS, (Object)24);
        }
        catch (ChannelException channelException) {
            // empty catch block
        }
        channel.config().setAllocator((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
        GlowStoneConnectionImpl connection = new GlowStoneConnectionImpl(ServerPlatform.get().getMiscUtils().getNetworkManagerFromChannel(channel));
        connection.storeInChannel(channel);
        ProtocolStorage.addConnection(channel.remoteAddress(), connection);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.remove("readtimeout");
        pipeline.remove("legacy_ping");
        pipeline.remove("encryption");
        pipeline.remove("writeidletimeout");
        pipeline.remove("compression");
        pipeline.addFirst("readtimeout", (ChannelHandler)new SimpleReadTimeoutHandler(30));
        pipeline.addAfter("readtimeout", "ps_initial_decoder", (ChannelHandler)new InitialPacketDecoder());
        pipeline.addBefore("handler", "ps_glowstone_sync_ticker", (ChannelHandler)new GlowStoneSyncConnectionTicker());
        pipeline.addBefore("handler", "ps_logic", (ChannelHandler)new LogicHandler(connection));
        pipeline.replace("framing", "framing", (ChannelHandler)new GlowStoneFramingHandler());
    }
}

